/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _Sb_CPUID_H_
#define _Sb_CPUID_H_

#include <Inventor/sys/port.h>

// currently only support win32 and gcc on x86
#if defined(_WIN32) || (defined(__GNUC__) && (defined(__i386__) || defined(__x86_64__)))
# define OIV_BUILD_OPTIMIZED 1
#else
# define OIV_BUILD_OPTIMIZED 0
#endif

class INVENTORBASE_API SbCPUID {
public:
  static bool sseSupported();
  static bool sse2Supported();
  static bool sse3Supported();
  static bool mmxSupported();

private:
  static void doCPUCheck();
  static void doCPUID(unsigned int what, unsigned int* features);
  static bool m_sseSupported;
  static bool m_mmxSupported;
  static bool m_sse2Supported;
  static bool m_sse3Supported;
  static bool m_featuresTested;
};

#endif


