/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SB_CYLINDER_
#define _SB_CYLINDER_

#include <Inventor/SbBase.h>
#include <Inventor/SbLine.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SbCylinder
//
//  Represents a cylinder in 3D space.
//
//////////////////////////////////////////////////////////////////////////////


/**
* Class for representing a cylinder.
*
* @ingroup Basics
*
* @DESCRIPTION
*   This class defines a simple cylinder datatype. It is used by the Open Inventor
*   toolkit for arguments or return values.
*
* @SEE_ALSO
*    SbVec3f,
*    SbLine,
*    SbPlane,
*    SbSphere,
*    SoCylinder
*
* [OIVJAVA-WRAPPER-CLASS BASIC_TYPE{true},LAYOUTED_ARRAY_TYPE{float,7}]
*/
class INVENTORBASE_API SbCylinder {
public:
  /**
  * Default constructor.  The cylinder is oriented along the Y axis
  * and has a radius of 1.
  */
  SbCylinder();

  /**
  * Constructor that takes an axis and radius.
  */
  SbCylinder(const SbLine &a, float r);

  /**
  * Change the axis and radius.
  */
  void   setValue(const SbLine &a, float r);

  /**
  * Set the axis.
  */
  void  setAxis(const SbLine &a);
  /**
  * Set the radius.
  */
  void  setRadius(float r);

  /**
  * Return the axis.
  */
  const SbLine &getAxis() const  { return axis; }
  /**
  * Return the radius.
  */
  float    getRadius() const    { return radius; }

  /**
  * Intersect line and cylinder, returning TRUE if there is an intersection.
  * [OIVJAVA-WRAPPER NAME{intersectFirst}]
  */
  SbBool  intersect(const SbLine &l, SbVec3f &intersection) const;
  /**
  * Intersect line and cylinder, returning TRUE if there is an intersection.
  */
  SbBool  intersect(const SbLine &l,
    SbVec3f &enter, SbVec3f &exit) const;

private:
  SbLine  axis;
  float  radius;

  static SbBool unitCylinderIntersect(const SbLine &l,
    SbVec3f &in, SbVec3f &out);

};


#endif /* _SB_CYLINDER_ */


