/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
// SbElapsedTime.h

#ifndef _SB_ELAPSED_TIME_H_
#define _SB_ELAPSED_TIME_H_

#include <Inventor/SbBase.h>
#include <Inventor/SbTime.h>
#include <Inventor/STL/iostream>

/**
 * @VSGEXT Class for measuring elapsed time with high resolution.
 *
 * @ingroup Basics
 *
 * @DESCRIPTION
 *   This measures elapsed time in seconds. It uses the highest resolution timer
 *   available on the system, to allow measuring very short intervals.  There is
 *   no guarantee the timer resolution will be better than SbTime (which is used
 *   if no better method is available).
 *
 *
 */
class INVENTORBASE_API SbElapsedTime {

 public:
  /**
   * Constructor (initializes timer)
   */
  SbElapsedTime();

  /**
   * Resets timer.
   */
  void reset();

  /**
   * Gets elapsed time in seconds.
   */
  double getElapsed() const;

  /**
   * Gets elapsed time.
   */
  SbTime getElapsedTime() const;

 SoINTERNAL public:

  /**
   * Gets an opaque timestamp value.
   * 
   * The returned value has no public meaning, and must only be used to be compare
   * with an other timestamp value to check for object lifetime for example.
   */
  static uint64_t getTimeStamp();

  /**
   * Writes the time to the specified output stream.
   */
  INVENTORBASE_API friend std::ostream& operator << (std::ostream& os, const SbElapsedTime& t);

 private:
  /**
   * Does this system have a hi-res timer?
   */
  static SbBool hasHiResTimer();

  // Does this system have a hi-res timer?
  static SbBool haveHiRes;

  // Set by constructor and reset method
  SbTime m_startTime;

#ifdef _WIN32
  // Frequency of high performance counter
  static double m_frequency;

  // Set by constructor and reset method
  LARGE_INTEGER m_startCount;
#endif
};

#endif //_SB_ELAPSED_TIME_H_

