/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef SBENUMS_H
#define SBENUMS_H

#include <Inventor/SbBase.h>

SoINTERNAL class SbEnums
{
public:
  /**
   * Specifies the different possible values of the texture-coordinate generation function.
   */
  enum TexGenFunction
  {
    TEXGEN_OBJECT_LINEAR, /** texCoordValue = dot(texGenCoeffs, objectSpaceVertex) */
    TEXGEN_EYE_LINEAR, /** texCoordValue = dot(texGenCoeffs, eyeSpaceVertex)    */
    TEXGEN_SPHERE_MAP,
    TEXGEN_NORMAL_MAP,
    TEXGEN_REFLECTION_MAP
  };

  /**
   * @brief Enumerates the different texture addressing options
   */
  enum TextureAddressMode
  {
    //Hardcoded value are here to keep iv file compatibity
    TEX_ADDRESS_MIRROR_CLAMP = 0,
    TEX_ADDRESS_CLAMP = 0x2900,
    TEX_ADDRESS_REPEAT = 0x2901,
    TEX_ADDRESS_CLAMP_BORDER =  0x812D,
    TEX_ADDRESS_CLAMP_TO_EDGE = 0x812F,
    TEX_ADDRESS_MIRROR_REPEAT = 0x8370
  };

  enum ImageUsage
  {
    IMG_USAGE_NONE = 0,
    IMG_USAGE_RTT = 1,
    IMG_USAGE_TRANSFER_DST = 2,
    IMG_USAGE_DATA = 4,
    IMG_USAGE_STORAGE = 8
  };

  enum MemoryType
  {
    MEM_TYPE_NONE = 0,
    MEM_TYPE_CPY_TO_CPU = 1,
    MEM_TYPE_EXTERNAL = 2 // Only for the interop Vulkan/OpenGL
  };

  /**
   * @brief Enumerates the different image data formats
   */
  enum ImageDataFormat
  {
    IMG_FORMAT_DEPTH_COMPONENT,
    IMG_FORMAT_STENCIL_INDEX,
    IMG_FORMAT_DEPTH_STENCIL,
    IMG_FORMAT_RED,
    IMG_FORMAT_GREEN,
    IMG_FORMAT_BLUE,
    IMG_FORMAT_RG,
    IMG_FORMAT_RGB,
    IMG_FORMAT_RGBA,
    IMG_FORMAT_BGR,
    IMG_FORMAT_BGRA,
    IMG_FORMAT_RED_INTEGER,
    IMG_FORMAT_GREEN_INTEGER,
    IMG_FORMAT_BLUE_INTEGER,
    IMG_FORMAT_RG_INTEGER,
    IMG_FORMAT_RGB_INTEGER,
    IMG_FORMAT_RGBA_INTEGER,
    IMG_FORMAT_BGR_INTEGER,
    IMG_FORMAT_BGRA_INTEGER
  };

  /**
   * @brief Enumerates the different shader type
   */
  enum ShaderType
  {
    SHADER_TYPE_VERTEX,
    SHADER_TYPE_GEOMETRY,
    SHADER_TYPE_FRAGMENT,
    SHADER_TYPE_TESS_CTRL,
    SHADER_TYPE_TESS_EVAL,
    SHADER_TYPE_COMPUTE,
    SHADER_TYPE_LAST
  };

  /**
   * @brief Enumerates the different blend factor
   */
  enum BlendFactor
  {
    BLEND_ZERO,
    BLEND_ONE,
    BLEND_SRC_COLOR,
    BLEND_ONE_MINUS_SRC_COLOR,
    BLEND_DST_COLOR,
    BLEND_ONE_MINUS_DST_COLOR,
    BLEND_SRC_ALPHA,
    BLEND_ONE_MINUS_SRC_ALPHA,
    BLEND_DST_ALPHA,
    BLEND_ONE_MINUS_DST_ALPHA,
    BLEND_CONSTANT_COLOR,
    BLEND_ONE_MINUS_CONSTANT_COLOR,
    BLEND_CONSTANT_ALPHA,
    BLEND_ONE_MINUS_CONSTANT_ALPHA,
    BLEND_SRC_ALPHA_SATURATE,
    BLEND_SRC1_COLOR,
    BLEND_ONE_MINUS_SRC1_COLOR,
    BLEND_SRC1_ALPHA,
    BLEND_ONE_MINUS_SRC1_ALPHA
  };

  /**
  * @brief Access mode for Buffer
  */
  enum BufferAccess
  {
    READ,
    WRITE,
    READ_WRITE
  };

  /**
   * @brief Enumerates the different blending functions
   */
  enum BlendFunction
  {
    BLEND_FUNC_ADD,
    BLEND_FUNC_SUBTRACT,
    BLEND_FUNC_REVERSE_SUBTRACT,
    BLEND_FUNC_MIN,
    BLEND_FUNC_MAX
  };

  /**
  * @brief Enumerate on which type of rendering PolygonOffset is applied
  */
  enum OffsetMode
  {
    OFFSET_SOLID = 0x01,
    OFFSET_WIREFRAME = 0x02,
    OFFSET_POINTS = 0x04
  };

  /**
   * @brief Enumerates the different depth/stencil comparison functions
   */
  enum ComparisonFunction
  {
    COMP_FUNC_NEVER = 0,
    COMP_FUNC_LESS,
    COMP_FUNC_LESS_EQUAL,
    COMP_FUNC_GREATER,
    COMP_FUNC_GREATER_EQUAL,
    COMP_FUNC_EQUAL,
    COMP_FUNC_NOT_EQUAL,
    COMP_FUNC_ALWAYS
  };

  /**
  * @brief Enumerates the different per pixel logical operations
  */
  enum LogicalOperation
  {
    LOGIC_OP_NOOP,
    LOGIC_OP_CLEAR,
    LOGIC_OP_SET,
    LOGIC_OP_COPY,
    LOGIC_OP_COPY_INVERTED,
    LOGIC_OP_INVERT,
    LOGIC_OP_AND,
    LOGIC_OP_NAND,
    LOGIC_OP_AND_REVERSE,
    LOGIC_OP_AND_INVERTED,
    LOGIC_OP_OR,
    LOGIC_OP_NOR,
    LOGIC_OP_XOR,
    LOGIC_OP_OR_REVERSE,
    LOGIC_OP_OR_INVERTED,
    LOGIC_OP_EQUIV,
  };

  /*
   * @brief Defines memory barrier available bitfields
   */
  enum MemoryBarrier
  {
    MEM_VERTEX_ATTRIB_ARRAY = 1,
    MEM_ELEMENT_ARRAY = 1 << 1,
    MEM_UNIFORM = 1 << 2,
    MEM_TEXTURE_FETCH = 1 << 3,
    MEM_SHADER_IMAGE_ACCESS = 1 << 4,
    MEM_COMMAND = 1 << 5,
    MEM_PIXEL_BUFFER = 1 << 6,
    MEM_TEXTURE_UPDATE = 1 << 7,
    MEM_BUFFER_UPDATE = 1 << 8,
    MEM_FRAMEBUFFER = 1 << 9,
    MEM_TRANSFORM_FEEDBACK = 1 << 10,
    MEM_QUERY_BUFFER = 1 << 11,
    MEM_ATOMIC_COUNTER = 1 << 12,
    MEM_CLIENT_MAPPED_BUFFER = 1 << 13,
    MEM_SHADER_STORAGE = 1 << 14,
    MEM_ALL = 0xFFFFFFFF
  };

  enum { OIV_MAX_FIXED_TEXTURE_UNIT  = 4 };
  
  /**
  * @brief Enumerates the different texture model options
  */
  enum TextureModel
  {
    TEX_MODEL_MODULATE = 0x2100,
    TEX_MODEL_DECAL = 0x2101,
    TEX_MODEL_BLEND = 0x0BE2,
    TEX_MODEL_REPLACE = 0x1E01,
    TEX_MODEL_ADD = 0x0104,
    TEX_MODEL_COMBINE = 0x8570,
    TEX_MODEL_ADD_SIGNED = 0x8574,
    TEX_MODEL_INTERPOLATE = 0x8575,
    TEX_MODEL_SUBTRACT = 0x84E7,
    TEX_MODEL_DOT3_RGB = 0x86AE,
    TEX_MODEL_DOT3_RGBA = 0x86AF
  };

  /**
  * @brief Enumerates the different texture filters
  */
  enum TextureFilter
  {
    TEX_FILTER_AUTO = 0,
    TEX_FILTER_NEAREST = 0x2600,
    TEX_FILTER_LINEAR = 0x2601,
    TEX_FILTER_NEAREST_MIPMAP_NEAREST = 0x2700,
    TEX_FILTER_NEAREST_MIPMAP_LINEAR = 0x2702,
    TEX_FILTER_LINEAR_MIPMAP_NEAREST = 0x2071,
    TEX_FILTER_LINEAR_MIPMAP_LINEAR = 0x2073
  };

  /**
  * @brief Enumerates the different source parameter
  */
  enum SourceParameter
  {
    SRC_PARAM_CONSTANT = 0x8576,
    SRC_PARAM_PRIMARY_COLOR = 0x8577,
    SRC_PARAM_PREVIOUS = 0x8578,
    SRC_PARAM_TEXTURE = 0x1702
  };

  /**
  * @brief Specifies the input mapping for the RGB and
  * alpha portions of operand n.
  */
  enum OperandRGBA
  {
    SRC_COLOR = 0x0300,
    ONE_MINUS_SRC_COLOR = 0x0301,
    SRC_ALPHA = 0x0302,
    ONE_MINUS_SRC_ALPHA = 0x0303
  };

  /**
   * @brief Defines the types of GPU Queries available
   */
  enum QueryType
  {
    QUERY_SAMPLES_PASSED,
    QUERY_ANY_SAMPLES_PASSED,
    QUERY_ANY_SAMPLES_PASSED_CONSERVATIVE,
    QUERY_PRIMITIVES_GENERATED,
    QUERY_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN,
    QUERY_TIME_ELAPSED,
    QUERY_TIMESTAMP
  };

  /**
   * @brief Defines the types of shader buffer types available
   */
  enum ShaderBufferType
  {
    SHADER_STORAGE_BUFFER,
    UNIFORM_BUFFER
  };

  /**
   * @brief Defines the types of shader buffer types available
   */
  enum FogType
  {
    FOG_TYPE_NONE = 0,
    FOG_TYPE_EXP,
    FOG_TYPE_EXP2,
    FOG_TYPE_LINEAR,
  };

};

#endif
