/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  SB_VERTEXATTRIBUTE_BINDING_H
#define  SB_VERTEXATTRIBUTE_BINDING_H

#include <Inventor/SbBase.h>

/**
 * Class encoding a binding type
 *
 * @ingroup Basics
 *
 * @DESCRIPTION
 *   This is a basic Open Inventor type is used to vaoid different binding
 *   values within Open Inventor.
 *
 * @SEE_ALSO
 *   SoMemoryObject,
 *   SoSFArray2D,
 *   SoSFArray3D
 *
 *
 */
class INVENTORBASE_API SbVertexAttributeBinding
{
public:
  /**
  * Supported Bindings
  */
  enum Binding
  {
    /**
    *  Whole object has same attribute.
    */
    OVERALL = 2,
    /**
    *  One attribute for each part of object.
    */
    PER_PART = 3,
    /**
    *  One attribute for each part, indexed.
    */
    PER_PART_INDEXED = 4,
    /**
    *  One attribute for each face of object.
    */
    PER_FACE = 5,
    /**
    *  One attribute for each face, indexed.
    */
    PER_FACE_INDEXED = 6,
    /**
    *  One attribute for each vertex.
    */
    PER_VERTEX = 7,
    /**
    *  One attribute for each vertex, indexed.
    */
    PER_VERTEX_INDEXED = 8
  };
  
private:
  SbVertexAttributeBinding(){}
};

#endif // SB_VERTEXATTRIBUTE_BINDING_H


