/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#ifndef MFCEventToSoEvent_h
#define MFCEventToSoEvent_h

#include <Inventor/ViewerComponents/MFC/StdAfx.h>

#include <Inventor/ViewerComponents/SoEventBuilder.h>
#include <Inventor/Events/SoMouseButtonEvent.h>

class RenderArea;

/**
 * @ingroup ViewerComponentsMFC
 */
class MFCVIEWERCOMPONENTS_API MFCEventToSoEvent
{

public:

  /**
   * Transform a MFC mouse press event to a SoMouseButtonEvent
   */
  static SoMouseButtonEvent* getMousePressEvent( CPoint loc, SoMouseButtonEvent::Button button, RenderArea* renderArea );

  /**
   * Transform a MFC mouse release event to a SoMouseButtonEvent
   */
  static SoMouseButtonEvent* getMouseReleaseEvent( CPoint loc, SoMouseButtonEvent::Button button, RenderArea* renderArea );

  /**
   * Transform a MFC mouse double click event to a SoMouseButtonEvent
   */
  static SoMouseButtonEvent* getMouseDoubleClickEvent( CPoint loc, SoMouseButtonEvent::Button button, RenderArea* renderArea );

  /**
   * Transform a MFC mouse move event to a SoLocation2Event
   */
  static SoLocation2Event* getMouseMoveEvent( CPoint loc, RenderArea* renderArea );

  /**
   * Transform a MFC mouse wheel event to a SoMouseWheelEvent
   */
  static SoMouseWheelEvent* getMouseWheelEvent( short zDelta, RenderArea* );

  /**
   * Transform a MFC mouse enter in the window event to a SoLocation2Event
   */
  static SoLocation2Event* getMouseEnterEvent( RenderArea* );

  /**
   * Transform a MFC mouse leave the window event to a SoLocation2Event
   */
  static SoLocation2Event* getMouseLeaveEvent( RenderArea* );

  /**
   * Transform a MFC key press event to a SoKeyboardEvent
   */
  static SoKeyboardEvent* getKeyPressEvent( WPARAM param, RenderArea* );

  /**
   * Transform a MFC key release event to a SoKeyboardEvent
   */
  static SoKeyboardEvent* getKeyReleaseEvent( WPARAM param, RenderArea* );

private:
  static bool initClass();
  static bool s_init;

  static SoKeyboardEvent::Key getIvKey( WPARAM param );
  static SoEventBuilder m_ivEvent;

  static SoKeyboardEvent::Key keyMap[256];
  static int keyMapInitFlag;

  static bool m_ctrlModifier;
  static bool m_altModifier;
  static bool m_shiftModifier;
};

#endif // MFCEventToSoEvent
