/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
#ifndef RenderAreaExaminer_H
#define RenderAreaExaminer_H

#include <Inventor/ViewerComponents/MFC/RenderAreaInteractive.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>
#include <Inventor/ViewerComponents/nodes/SiInteractionModeListener.h>

/**
 * Class to render an OpenInventor scene in an Win32 OpenGL window.
 * This class extends RenderAreaInteractive to add examiner system
 *
 * Note: When using this component, the automatic interactive mode is disabled,
 * see SoSceneManager::setAutoInteractiveMode for more details.
 * Interactive mode is managed by the SceneExaminer node.
 *
 * @ingroup ViewerComponentsMFC
 */
class MFCVIEWERCOMPONENTS_API RenderAreaExaminer : public RenderAreaInteractive, public SiInteractionModeListener
{
 public:
  /**
   * Constructor
   */
  RenderAreaExaminer();

  /**
   * Returns the scene examiner
   * @return The scene examiner
   */
  SoDEPRECATED_METHOD(10500,"Use getSceneInteractor() method instead.")
  SceneExaminer* getSceneExaminer();

  /**
   * Returns the scene examiner.
   * @return The scene examiner
   */
  virtual SceneExaminer* getSceneInteractor() const override;

  /**
  * Sets navigation mode.
  */
  virtual void setNavigationMode( SceneExaminer::NavigationMode mode );

  /**
  * Returns the current navigation mode.
  */
  virtual SceneExaminer::NavigationMode getNavigationMode();

  /**
  * This method is called when the seek mode is activated and deactivated.
  */
  void seekModeChanged(const bool onOrOff);

  /**
  * This method is called when the interaction has changed.
  */
  void interactionModeChanged(SceneExaminer::InteractionMode mode);

  /**
  * This method is a callback of the SetCursor function.
  */
  afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);

private:
  static HCURSOR s_seekCursor;
  static HCURSOR s_viewingCursor;
  static HCURSOR s_selectionCursor;

  HCURSOR s_currentCursor;

  SceneExaminer* m_examinerRootSceneGraph;

  /**
  * This method sets the cursor according to interaction mode.
  */
  void updateInteractionCursor();

  DECLARE_MESSAGE_MAP()
};

#endif // RenderAreaExaminer_H
