/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef SI_RENDERAREA_INTERACTIVE
#define SI_RENDERAREA_INTERACTIVE

#include <Inventor/events/SoEvent.h>
#include <Inventor/nodes/SoInteractiveComplexity.h>

/**
* @VSGEXT RenderArea interactive interface.
*
* @ingroup ViewerComponents
*
* @DESCRIPTION
*
* This interface provides the list of methods that renderAreas must define to use interactive feature.
*
* @SEE_ALSO
*   SoRenderAreaCore, RenderAreaInteractive
*
*/
class INVENTOR_API SiRenderAreaInteractive
{

public:

#if SoDEPRECATED_BEGIN(101000)
  /**
   * Set the current interactive mode.
   */
  SoDEPRECATED_METHOD_NOWARN( 101000, "Use SoInteractiveComplexity node instead." )
  virtual void setInteractiveMode( SoInteractiveComplexity::InteractiveMode mode ) = 0;

  /**
   * @see setInteractiveMode().
   */
  SoDEPRECATED_METHOD_NOWARN( 101000, "Use SoInteractiveComplexity node instead." )
  virtual SoInteractiveComplexity::InteractiveMode getInteractiveMode() const = 0;
#endif /** @DEPRECATED_END */

  /**
   * Processes the passed event to the scene graph managed here.
   * Returns TRUE if the event was handled by a node.
   */
  virtual SbBool processEvent(const SoEvent *event) = 0;

  /**
   * Processes the passed event to the scene graph managed here.
   * Returns TRUE if at least one event was handled by a node.
   */
  virtual SbBool processEvents(const std::vector<const SoEvent*>& eventList) = 0;


};

#endif // SI_RENDERAREA_INTERACTIVE
