/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef _SO_STEREO_PARAMETERS_
#define _SO_STEREO_PARAMETERS_

#include <Inventor/sys/port.h>

/**
 * @VSGEXT Stereo parameters base class.
 *
 * @ingroup ViewerComponents
 *
 * @DESCRIPTION
 * This class is the base class for all the parameters classes used for
 * the different stereo mode. These objects are used with the
 * method SoRenderAreaCore::setStereo() to activate stereo rendering.
 *
 * @SEE_ALSO
 *    SoRawStereoParameters
 *
 */
class INVENTOR_API SoStereoParameters
{

public:

  /** Default destructor */
  virtual ~SoStereoParameters();

  /**
   * Sets stereo reversal.  Default is false.
   * The left view becomes the right view, and the right view becomes the left view.
   * [OIVNET-WRAPPER PROPERTY{IsReversedView},SETTER]
   */
  void setReversedView( bool reversed );

  /**
   * Queries stereo reversal.
   * [OIVNET-WRAPPER PROPERTY{IsReversedView},GETTER]
   */
  bool isReversedView() const;

protected:

  /** Default constructor */
  SoStereoParameters();

private:

  bool m_isReversed;

};

#endif // _SO_STEREO_PARAMETERS_
