/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#ifndef RenderAreaExaminer_H
#define RenderAreaExaminer_H

#include <Inventor/ViewerComponents/Win/RenderAreaInteractive.h>
#include <Inventor/ViewerComponents/nodes/SiInteractionModeListener.h>

class SceneExaminer;

/**
 * Class to render an OpenInventor scene graph in a Win32 OpenGL window.
 * This class extends RenderAreaInteractive to add examiner viewer behaviors.
 *
 * Note: When using this component, the automatic interactive mode is disabled,
 * see SoSceneManager::setAutoInteractiveMode for more details.
 * Interactive mode is managed by the SceneExaminer node.
 *
 * @ingroup ViewerComponentsWin
 */
class WINVIEWERCOMPONENTS_API RenderAreaExaminer : public RenderAreaInteractive, public SiInteractionModeListener
{
 public:
  /** Constructor */
  RenderAreaExaminer();

  /**
   * Returns the scene examiner.
   * @return The scene examiner
   */
  SoDEPRECATED_METHOD(10500,"Use getSceneInteractor() method instead.")
  SceneExaminer* getSceneExaminer();

  /**
   * Returns the scene examiner.
   * @return The scene examiner
   */
  virtual SceneExaminer* getSceneInteractor() const override;

  /**
   * This method is called to process windows events
   */
  virtual void processEvents( UINT uMsg, WPARAM wParam, LPARAM lParam );

  /**
   * This method is called when the seek mode is activated and deactivated.
   */
  virtual void seekModeChanged( const bool onOrOff );

  /**
   * This method is called when the interaction has changed.
   */
  virtual void interactionModeChanged( SceneExaminer::InteractionMode mode );

private:
  SceneExaminer* m_examinerRootSceneGraph;

  static HCURSOR s_seekCursor;
  static HCURSOR s_viewingCursor;
  static HCURSOR s_selectionCursor;

  HCURSOR s_currentCursor;

  /**
   * This method sets the cursor according to interaction mode.
   */
  void updateInteractionCursor();

};

#endif // RenderAreaExaminer_H
