/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SIINTERACTIONMODELISTENER
#define SIINTERACTIONMODELISTENER

#include <Inventor/sys/port.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

/** 
 * @DESCRIPTION
 * This interface provides the list of interaction methods that subclasses must define.
 *
 * Used with the SceneExaminer class. Application should derive a new class from this
 * one and pass an instance of that class to the addInteractionModeListener() method.
 *
 * @SEE_ALSO
 *  SceneExaminer
 * [OIV-WRAPPER-CLASS NO_WRAP]
 */
class VIEWERCOMPONENTS_API SiInteractionModeListener
{
public:
  
  /**
   * This method is called when the seek mode is activated and deactivated. 
   */
  virtual void seekModeChanged(const bool onOrOff) = 0;

  /**
   * This method is called when the interaction has changed. 
   */
  virtual void interactionModeChanged(SceneExaminer::InteractionMode mode) = 0;
};


#endif // SIINTERACTIONMODELISTENER
