/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/



#ifndef  _SO_WIN_MOUSE_
#define  _SO_WIN_MOUSE_

#include <Inventor/Win/SoWinBeginStrict.h>
#include <windows.h>

#include <Inventor/Win/devices/SoWinDevice.h>
#include <Inventor/events/SoLocation2Event.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/events/SoMouseWheelEvent.h>

#define SO_WIN_ALL_MOUSE_EVENTS \
    (ButtonPressMask | ButtonReleaseMask | \
     PointerMotionMask | ButtonMotionMask)

/**
 * @VSGEXT Translates and reports messages for the mouse device.
 * 
 * @ingroup Win
 * 
 * @DESCRIPTION
 *   This class translates and manages messages generated by the mouse, 
 *   including mouse motion (SoLocation2Event), and mouse button press 
 *   and release messages (SoMouseButtonEvent).
 * 
 * @SEE_ALSO
 *    SoWinDevice,
 *    SoLocation2Event,
 *    SoMouseButtonEvent
 */
class INVENTORW_API SoWinMouse : public SoWinDevice {
 public:
  /**
   * Constructor. To the constructor, pass which mouse messages you
   * are interested in as a bitwise OR of the following values:
   * 
   * ButtonPressMask - Mouse down messages
   * 
   * ButtonReleaseMask - Mouse up messages
   * 
   * PointerMotionMask - Mouse motion with no buttons
   * 
   * ButtonMotionMask - Mouse motion with buttons pressed
   * 
   * Or simply pass the defined value SO_WIN_ALL_MOUSE_EVENTS for all mouse messages.
   * The device will only report messages of this type for the window it is enabled
   * on.
   */
  SoWinMouse(EventMask mask = SO_WIN_ALL_MOUSE_EVENTS);
  /**
   * Destructor. 
   */
  ~SoWinMouse();
    
  /** @copydoc SoWinDevice::enable() */
  virtual void        enable(SoWidget w, XtEventHandler f,
                             XtPointer data, Window win = NULL);

  /** @copydoc SoWinDevice::disable() */
  virtual void        disable(SoWidget w, XtEventHandler f, XtPointer data);
    
  /** @copydoc SoWinDevice::translateEvent() */
  virtual const SoEvent * translateEvent(XAnyEvent *xevent);
  
 private:
  EventMask           eventMask;      // X event interest for this device
  SoLocation2Event    *loc2Event;     // mouse motion
  SoMouseButtonEvent  *buttonEvent;   // mouse button press
  SoMouseWheelEvent   *mouseWheelEvent;

  // Keep the content of the time entry in the MSG structure for mouse leave/enter events
  unsigned long m_lastMoveTime; 
  int m_lastMoveX;
  int m_lastMoveY;
    
  bool m_mouseIsOutside;

  SoLocation2Event    *translateMotionEvent(XMotionEvent *me, bool isLeaveMotionEvent = false);

  SoMouseButtonEvent  *translateButtonEvent(XButtonEvent *be,
                                            SoMouseButtonEvent::Button b,
                                            SoButtonEvent::State s);
  SoMouseWheelEvent  *translateMouseWheelEvent(XMouseWheelEvent *we);

};

#include <Inventor/Win/SoWinEndStrict.h>

#endif /* _SO_WIN_MOUSE_ */

