/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef _WIN32
#  include <Inventor/Win/SoWinMaterialSliderSet.h>
#else // _WIN32

#ifndef _SO_XT_MATERIAL_SLIDER_SET_
#define _SO_XT_MATERIAL_SLIDER_SET_

#include <Inventor/Xt/SoXtSliderSet.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoXtMaterialSliderSet
//
//  For editing material nodes.
//
//  The SoXtMaterialSliderSet allocates:
//     1 SoXtAmbientColorSliderModule     (for editing ambient color )
//     1 SoXtDiffuseColorSliderModule     (for editing diffues color )
//     1 SoXtSpecularColorSliderModule    (for editing specular color )
//     1 SoXtEmissiveColorSliderModule    (for editing emissive color )
//     1 SoXtShininessSliderModule        (for editing shininess )
//     1 SoXtTransparencySliderModule     (for editing transparency )
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Component with Motif sliders for editing SoMaterial nodes.
 * 
 * @ingroup Xt
 * 
 * @DESCRIPTION
 *   This class defines an editor that uses Motif Sliders to edit the fields in an
 *   SoMaterial node. There are sliders for editing the RGB values of ambientColor,
 *   diffuseColor, specularColor and emissiveColor, as well as for editing the
 *   transparency and shininess values.
 * 
 * @RESOURCES
 * \verbatim
     !!------------------------------------------------
     !! Material Slider Set
     !!------------------------------------------------
     *IvMaterialSliderAmbient.labelString: AMBIENT
     *IvMaterialSliderAmbientRed.labelString: Ambient Red
     *IvMaterialSliderAmbientGreen.labelString: Ambient Green
     *IvMaterialSliderAmbientBleu.labelString: Ambient Blue
     *IvMaterialSliderDiffuse.labelString: DIFFUSE
     *IvMaterialSliderDiffuseRed.labelString: Diffuse Red
     *IvMaterialSliderDiffuseGreen.labelString: Diffuse Green
     *IvMaterialSliderDiffuseBleu.labelString: Diffuse Blue
     *IvMaterialSliderSpecular.labelString: SPECULAR
     *IvMaterialSliderSpecularRed.labelString: Specular Red
     *IvMaterialSliderSpecularGreen.labelString: Specular Green
     *IvMaterialSliderSpecularBleu.labelString: Specular Blue
     *IvMaterialSliderEmissive.labelString: EMISSIVE
     *IvMaterialSliderEmissiveRed.labelString: Emissive Red
     *IvMaterialSliderEmissiveGreen.labelString: Emissive Green
     *IvMaterialSliderEmissiveBlue.labelString: Emissive Blue
     *IvMaterialSliderShininess.labelString: SHININESS
     *IvMaterialSliderShininessShininess.labelString: shininess
     *IvMaterialSliderTransparency.labelString: TRANSPARENCY
     *IvMaterialSliderTransparencyTransparency.labelString: transparency
   \endverbatim
 * 
 * @SEE_ALSO
 *    SoXtMaterialEditor,
 *    SoXtSliderSet,
 *    SoXtSliderSetBase,
 *    SoXtComponent,
 *    SoMaterial,
 *    SoNode
 * 
 * 
 */ 

SoINTERNAL class INVENTORXT_API SoXtMaterialSliderSet : public SoXtSliderSet {
 public:
  /**
   * Constructor. At construction time the material node to edit can
   * be supplied.
   */
  SoXtMaterialSliderSet(
                        SoWidget parent = NULL,
                        const char *name = NULL, 
                        SbBool buildInsideParent = TRUE,
                        SoNode *newEditNode = NULL );
  /**
   * Destructor.
   */
  ~SoXtMaterialSliderSet();
    
 protected:

  // This constructor takes a boolean whether to build the widget now.
  // Subclasses can pass FALSE, then call the buildWidget() method on
  // this class when they are ready for it to be built.
  SoEXTENDER
    SoXtMaterialSliderSet(
                          SoWidget parent,
                          const char *name, 
                          SbBool buildInsideParent, 
                          SoNode *newEditNode,
                          SbBool buildNow);
    
  SoWidget      buildWidget( SoWidget parent);
  
  // this is called by both constructors
  void constructorCommon(SbBool buildNow);

};

#endif /* _SO_XT_MATERIAL_SLIDER_SET_ */

#endif // _WIN32


