/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef _WIN32
#  include <Inventor/Win/SoWinResource.h>
#else // _WIN32

#ifndef _SO_XTRESOURCE_
#define _SO_XTRESOURCE_

#include <X11/Intrinsic.h>
#include <X11/Xresource.h>
#include <Inventor/SbBasic.h>
#include <Inventor/SbColor.h>
#include <Inventor/Xt/SoXtDef.h>

/**
 * Used to retrieve X resources for SoXt components and widgets .
 *
 * @ingroup Xt
 *
 * @DESCRIPTION
 *   This class provides an easy-to-use interface for retrieving X resource values
 *   for widgets and components. Rather than use standard Xt calls to traverse up a
 *   widget hierarchy, this class performs its own traversal so that it may provide
 *   special care for widgets which are Open Inventor components. For instance, the
 *   Open Inventor Material Editor top level widget is a Motif form widget. Its class
 *   name is thus @B XmForm @b. SoXtResource knows that the editor is an Open
 *   Inventor component, though, so it uses the class name provided by the editor (in
 *   this case "SoXtMaterialEditor") when looking up resource values.
 *
 *   EXAMPLE:
 *
 *   \verbatim
      SoXtResource xr( materialEditor->getWidget() );
      xr.getResource("tile1Color", "Tile1Color", color);
      xr.getResource("updateFrequency", "UpdateFrequency", freq);
     \endverbatim
 *
 *
 * @NOTES
 *   Components will typically look up their own resources during buildWidget(). In
 *   order for a component to have its Open Inventor class name recognized by
 *   SoXtResource, it must call SoXtComponent::registerWidget() in its
 *   @B buildWidget @b() method. (This is done in every Open Inventor component.)
 *
 * @SEE_ALSO
 *    X Resources (Xrm),
 *    X Intrinsics (Xt),
 *    SoXt,
 *    SoXtComponent
 *
 *
 */
class INVENTORXT_API SoXtResource {
 public:
  /**
   * Constructor. The constructor takes the widget for which it will
   * retrieve resource values.
   */
  SoXtResource(SoWidget w);
  /**
   * Destructor.
   */
  ~SoXtResource();

  //
  // These methods look up X resource values by calling XrmQGetResource.
  // They return TRUE if successfully located the resource.
  //
  // NOTE: you do not have to specify the complete widget hierarchy.
  // This is automatically performed by this class. Simply name the
  // specific resource that should be searched for. The most efficient
  // use of this class is to construct an instance for a widget, then
  // call getResource repeatedly with different resource strings which
  // are valid for the widget.
  //
  // For example:
  //    SoXtResource xr(colorEditor->getWidget());
  //    xr.getResource("wysiwyg", "Wysiwyg", onOrOff);
  //    xr.getResource("colorSliders", "ColorSliders", rgbOrHsv);
  //    xr.getResource("updateFrequency", "UpdateFrequency", freq);

  /**
   * Returns the X resource value for the specified resource name and class.
   * There is no need to specify the widget hierarchy; this is automatically computed
   * in the constructor.
   */
  SbBool      getResource(char *resName, char *resClass, SbColor &c);
  /**
   * Returns the X resource value for the specified resource name and class.
   * There is no need to specify the widget hierarchy; this is automatically computed
   * in the constructor.
   */
  SbBool      getResource(char *resName, char *resClass, short &i);
  /**
   * Returns the X resource value for the specified resource name and class.
   * There is no need to specify the widget hierarchy; this is automatically computed
   * in the constructor.
   */
  SbBool      getResource(char *resName, char *resClass, unsigned short &u);
  /**
   * Returns the X resource value for the specified resource name and class.
   * There is no need to specify the widget hierarchy; this is automatically computed
   * in the constructor.
   */
  SbBool      getResource(char *resName, char *resClass, char *&s);
  /**
   * Returns the X resource value for the specified resource name and class.
   * There is no need to specify the widget hierarchy; this is automatically computed
   * in the constructor.
   */
  SbBool      getResource(char *resName, char *resClass, SbBool &b);
  /**
   * Returns the X resource value for the specified resource name and class.
   * There is no need to specify the widget hierarchy; this is automatically computed
   * in the constructor.
   */
  SbBool      getResource(char *resName, char *resClass, float &f);

 private:
  XrmQuarkList    nameList;
  XrmQuarkList    classList;
  int             listSize;
  Display         *display;

  // These methods look up X resource values by calling XrmGetResource.
  // e.g. getResource("*backgroundColor", "*BackgroundColor", c);
  // They return TRUE if successfully located the resource.

  static SbBool getResource(Display *, char *sName, char *sClass, SbColor &c);
  static SbBool getResource(Display *, char *sName, char *sClass, short &i);
  static SbBool getResource(Display *, char *sName, char *sClass, unsigned short &u);
  static SbBool getResource(Display *, char *sName, char *sClass, char *&s);
  static SbBool getResource(Display *, char *sName, char *sClass, SbBool &b);
  static SbBool getResource(Display *, char *sName, char *sClass, float &f);


  // These methods look up X resource values by calling XrmQGetResource.
  // That is, they use XrmQuarks instead of strings. (A quark is an Xrm
  // notion - it is simply a key into a hash table of strings.)
  // They are used by SoXtResource for SoComponents.
  // They return TRUE if successfully located the resource.

  static SbBool getResource(Display *, XrmQuarkList qName, XrmQuarkList qClass, SbColor &c);
  static SbBool getResource(Display *, XrmQuarkList qName, XrmQuarkList qClass, short &i);
  static SbBool getResource(Display *, XrmQuarkList qName, XrmQuarkList qClass, unsigned short &u);
  static SbBool getResource(Display *, XrmQuarkList qName, XrmQuarkList qClass, char *&s);
  static SbBool getResource(Display *, XrmQuarkList qName, XrmQuarkList qClass, SbBool &b);
  static SbBool getResource(Display *, XrmQuarkList qName, XrmQuarkList qClass, float &f);

};

#endif /* _SO_XTRESOURCE_ */

#endif // _WIN32


