/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef _WIN32
#  include <Inventor/Win/SoWinSliderSetBase.h>
#else // _WIN32

#ifndef _SO_XT_SLIDER_SET_BASE_
#define _SO_XT_SLIDER_SET_BASE_

#include <Inventor/Xt/SoXtComponent.h>
#include <Inventor/nodes/SoNode.h>

///////////////////////////////////////////////////////////////////////
//
// class: SoXtSliderSetBase
//
///////////////////////////////////////////////////////////////////////

/**
 * Abstract base class for Motif-only slider components.
 * 
 * @ingroup Xt
 * 
 * @DESCRIPTION
 *   This class is used as a base class for all editors which use Motif sliders to
 *   edit fields in an Open Inventor scene graph node. This class is not meant to be
 *   instanced by programmers who want to use an editor in a program. It should only
 *   be used as a base class when designing new editors.
 *   
 *   SoXtSliderSetBase is derived from SoXtComponent, but adds three concepts. First,
 *   there is a node to edit. Second, there are subcomponents. When an
 *   SoXtSliderSetBase is shown or hidden, so are its subcomponents. (As an example,
 *   an SoXtTransformSliderSet is composed of many subcomponents). Third, an
 *   SoXtSliderSetBase has a layout size, which is used to lay out the subcomponents.
 * 
 * @SEE_ALSO
 *    SoXtComponent,
 *    SoXtSliderSet
 * 
 * 
 */
class INVENTORXT_API SoXtSliderSetBase : public SoXtComponent {
 public:
  /**
   * Sets a new node as the node to be modified by this editor component. 
   */
  virtual void setNode( SoNode *newNode );

  /**
   * Returns a pointer to the node currently being modified by this editor component.
   */
  SoNode * getNode() const { return _editNode; }
  // internal:
  virtual void getLayoutSize( int &w, int &h );

  virtual void show();
      
 protected:
  SoWidget          widget;//??? huh? why not SoXtComponent::widget?

  int             _layoutWidth;
  int             _layoutHeight;
  SoNode          *_editNode;
  int             _numSubComponents;
  SoXtSliderSetBase **_subComponentArray;
  SoXtSliderSetBase(
                    SoWidget parent = NULL,
                    const char *name = NULL, 
                    SbBool buildInsideParent = TRUE,
                    SoNode *newEditNode = NULL);
  ~SoXtSliderSetBase();
};

#endif // _SO_XT_SLIDER_SET_BASE_

#endif // _WIN32


