/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef SOQT
#  include <Inventor/Qt/devices/SoQtMouse.h>
#elif defined _WIN32
#  include <Inventor/Win/devices/SoWinMouse.h>
#else // _WIN32

#ifndef  _SO_XT_MOUSE_
#define  _SO_XT_MOUSE_

#include <Inventor/Xt/devices/SoXtDevice.h>
#include <Inventor/events/SoLocation2Event.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/events/SoMouseWheelEvent.h>
#include <X11/X.h>

#define SO_XT_ALL_MOUSE_EVENTS \
    (ButtonPressMask | ButtonReleaseMask | \
     PointerMotionMask | ButtonMotionMask)

/**
 * Translates and reports events for the mouse device.
 *
 * @ingroup Xt
 *
 * @DESCRIPTION
 *   This class manages events generated by the mouse, including mouse motion
 *   (SoLocation2Event), and mouse button press and release events
 *   (SoMouseButtonEvent).
 *
 * @SEE_ALSO
 *    SoXtDevice,
 *    SoLocation2Event,
 *    SoMouseButtonEvent
 *
 *
 */
class INVENTORXT_API SoXtMouse : public SoXtDevice {
 public:
  /**
   * Constructor. To the constructor, pass which mouse messages you
   * are interested in as a bitwise OR of the following values:
   *
   * ButtonPressMask - Mouse down events
   *
   * ButtonReleaseMask - Mouse up events
   *
   * PointerMotionMask - Mouse motion with no buttons
   *
   * ButtonMotionMask - Mouse motion with buttons pressed
   *
   * Or simply pass the defined value SO_XT_ALL_MOUSE_EVENTS for all mouse events. The
   * device will only report events of this type for the window it is enabled on.
   */
  SoXtMouse(EventMask mask = SO_XT_ALL_MOUSE_EVENTS);
  /**
   * Destructor.
   */
  ~SoXtMouse();

  // These functions enable/disable this device for the passed widget.
  // The callback function f will be invoked when events occur in w.
  // data is the clientData which will be passed.
  virtual void        enable(SoWidget w, XtEventHandler f,
                             XtPointer data, Window win = (Window)NULL);
  virtual void        disable(SoWidget w, XtEventHandler f, XtPointer data);

  //
  // Converts an X event into an SoEvent,
  // returning NULL if the event is not from this device.
  //
  virtual const SoEvent * translateEvent(XAnyEvent *xevent);

 private:
  EventMask           eventMask;      // X event interest for this device
  SoLocation2Event    *loc2Event;     // mouse motion
  SoMouseButtonEvent  *buttonEvent;   // mouse button press
  SoMouseWheelEvent   *m_wheelEvent;    // wheel

  SoLocation2Event    *translateMotionEvent(XMotionEvent *me);
  SoMouseButtonEvent  *translateButtonEvent(XButtonEvent *be, SoButtonEvent::State s);
  SoMouseWheelEvent *translateWheelEvent(XButtonEvent *be);

  // Time of the last ButtonRelease
  SbTime lastReleaseButtonEvent;
  // Used to identify double-click separating the call to translateEvent by
  // processInventorEvent and invokeAppCB.
  int callNumber;
  // Double-click timing. Can be set with OIV_XT_DBLCLK_TIMING
  float doubleClickTiming;

};

#endif /* _SO_XT_MOUSE_ */

#endif // _WIN32


