/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD (Jul 1997)
**=======================================================================*/

#ifdef SOQT
#  include <Inventor/Qt/viewers/SoQtCollisionViewer.h>
#elif defined _WIN32
#  include <Inventor/Win/viewers/SoWinCollisionViewer.h>
#else // _WIN32

#ifndef _SO_XT_COLLISION_VIEWER_
#define _SO_XT_COLLISION_VIEWER_

#include <Inventor/SbBase.h>

//------------------------------------------------------------------------------
// Types declaration
class SoXtCollisionViewer;
class SoXtViewer;
class SoCollisionViewerImpl;


//------------------------------------------------------------------------------
// Types definition
/** @memberof SoXtCollisionViewer */
typedef void SoXtCollisionViewerCB 
(void *userData, SoXtCollisionViewer *collisionViewer);



/**
 * @VSGEXT Class to manage collisions between the camera and the scene.
 * 
 * @ingroup collision
 * 
 * @DESCRIPTION
 *   This class is used to constrain a viewer, preventing the viewer's camera from
 *   colliding with the objects in the scene. It overrides the RenderCallback on the
 *   viewer that it's attached to.
 *   
 *   The programmer can define the maximum distance between the camera and the
 *   objects.
 *   
 *   When Z-buffer optimization is enabled, the algorithm looks at the Z-buffer to see
 *   if there is an object in front of the camera when the user moves forward, and an
 *   SoIntersectionDetectionAction when the user moves backward.
 *   
 *   NOTE: This class is @I not @i a viewer.
 * 
 * @SEE_ALSO
 *    SoCollisionManager,
 *    SoIntersectionDetectionAction
 * 
 * 
 */
class INVENTORXT_API SoXtCollisionViewer
{

public :

  /**
   * Constructor.
   */
  SoXtCollisionViewer(SoXtViewer *viewer);
  /**
   * Destructor.
   */
  ~SoXtCollisionViewer();

  /**
   * Gets the original viewer.
   */
  SoXtViewer *getViewer() const;
 
  /**
   * Sets the distance between the camera and the objects.
   */
  void setDistance(float distance);
  /**
   * Gets the distance between the camera and the objects.
   */
  float getDistance() const;

  /**
   * Sets the number of steps to be used in the collision computation. The
   * default number of steps is 4. The minimum value is 2.
   */
  void setNumSteps(int num_steps);
  /**
   * Gets the number of steps to be used in the collision computation.
   */
  int getNumSteps() const; 

  /**
   * Sets the collision detection flag. The default value is TRUE.
   */
  void setCollisionDetection(SbBool value = TRUE);
  /**
   * Gets the collision detection flag.
   */
  SbBool getCollisionDetection() const;
 
  /**
   * Sets the Z buffer optimization flag. The default value is TRUE.
   *
   * Also sets the useZBufferOnly flag.  When this flag is TRUE, the
   * geometric collision detection algorithm is never used.  Therefore there
   * is no collision check when the camera is moving backward, but this may
   * be desireable for large scenes when this check is too slow.
   */
  void setZBufferOptimization(SbBool value = TRUE, SbBool useZBufferOnly = FALSE);
  /**
   * Gets the Z buffer optimization flag.
   */
  SbBool getZBufferOptimistation() const;

  /**
   * Adds a callback. This callback is called when a collision occurs
   * between the camera and the scene.
   */
  void addCallback(SoXtCollisionViewerCB* f, void* ud = NULL);
  /**
   * Removes the callback.
   */
  void removeCallback(SoXtCollisionViewerCB* f, void* ud = NULL);

private:
  SoCollisionViewerImpl* m_impl;
};

#endif//_SO_XT_COLLISION_VIEWER_

#endif // _WIN32


