/*=============================================================================
** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),       **
**              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                **
**                                                                           **
**  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  **
**  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  **
**  WRITTEN AUTHORIZATION OF FEI S.A.S.                                      **
**                                                                           **
**                        RESTRICTED RIGHTS LEGEND                           **
**  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS **
**  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN **
**  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT **
**  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN **
**  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        **
**                                                                           **
**                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                   **
**                             BORDEAUX, FRANCE                              **
**                           ALL RIGHTS RESERVED                             **
=============================================================================*/

#pragma once

#include <Inventor/actions/SoHighlightRenderAction.h>
#include <Inventor/nodes/SoGroup.h>

class SbViewportRegion;
class SoMaterial;

/**
 * A polygon selection highlight style.
 *
 * @ingroup actions
 *
 * @DESCRIPTION
 *   SoColorHighlightRenderAction is a render action which renders the
 *   scene graph and then renders again the polygons of selected objects
 *   in a highlight color.Selected objects are specified by the first
 *   SoSelection node in the scene to which this action is applied. A
 *   highlight render action can be passed to the setGLRenderAction() method
 *   of render area and viewer classes to have an effect on scene
 *   graphs.
  * @EXAMPLE
 *   Here is an example of how a box highlight can be specified for a particular
 *   selection node and viewer:
 *   \if_cpp
 *     \code
 *     // Scene graph
 *     SoSelection selectionNode  = new SoSelection();
 *     . . .
 *     // Viewer
 *     SoWinExaminerViewer* viewer = new SoWinExaminerViewer();
 *     viewer->setSceneGraph( selectionNode );
 *
 *     // Set the highlight render action
 *     viewer->setGLRenderAction( new SoColorHighlightRenderAction() );
 *
 *     // Request automatic redraw when selection changes
 *     viewer->redrawOnSelectionChange( selectionNode );
 *     \endcode
 *   \endif
 *   \if_dotnet
 *     \code
 *     // Scene graph
 *     SoSelection selectionNode  = new SoSelection();
 *     . . .
 *     // Viewer
 *     SoWinExaminerViewer viewer = new SoWinExaminerViewer();
 *     viewer.SetSceneGraph( selectionNode );
 *
 *     // Set the highlight render action
 *     viewer.SetGLRenderAction( new SoColorHighlightRenderAction() );
 *
 *     // Request automatic redraw when selection changes
 *     viewer.RedrawOnSelectionChange( selectionNode );
 *     \endcode
 *   \endif
 *   \if_java
 *     \code
 *     // Viewer
 *     ViewerExaminer viewer = new ViewerExaminer();
 *     // Set the highlight render action
 *     final RenderArea area = viewer.getRenderArea();
 *     area.setGLRenderAction( new SoColorHighlightRenderAction() );
 *
 *     // Scene graph
 *     SoSelection selectionNode  = new SoSelection();
 *
 *     // Request automatic redraw when selection changes
 *     selectionNode.addChangeCallback(new SoSelectionClassCB()
 *     {
 *       public void invoke(SoSelection s)
 *       {
 *         area.scheduleRedraw();
 *       }
 *     });
 *     . . .
 *     viewer.setSceneGraph( selectionNode );
 *     \endcode
 *   \endif
 *
 * @SEE_ALSO
 *    SoLineHighlightRenderAction,
 *    SoBoxHighlightRenderAction,
 *    SoHaloHighlightRenderAction,
 *    SoHighlightRenderAction,
 *    SoGLRenderAction,
 *    SoSelection,
 *    SoWinRenderArea,
 *    SoDrawStyle,
 *    SoInteraction
 *
 *
 */

class INVENTOR_API SoColorHighlightRenderAction : public SoHighlightRenderAction
{
  SO_ACTION_HEADER(SoColorHighlightRenderAction);
public:
  SoColorHighlightRenderAction();
  SoColorHighlightRenderAction(const SbViewportRegion &viewportRegion);

  virtual ~SoColorHighlightRenderAction();

  /**
   * Sets the color of the highlight. Default is red (1,0,0). The application
   * is responsible for forcing a redraw of the scene to see the effects of this
   * change.
   */
  void setColor(const SbColor& c);

  /**
   * Gets the color of the highlight.
   */
  const SbColor& getColor() const;

  static void initClass();
  static void exitClass();

protected:
  /** @copydoc SoHighlightRenderAction::getPreTraversalNode() */
  virtual SoNode* getPreTraversalNode();

private:
  // Copy Constructor Forbidden
  SoColorHighlightRenderAction( const SoColorHighlightRenderAction& ) : SoHighlightRenderAction() {}

  void constructorCommon();

  SoRef<SoGroup> m_preTraversalNode;
  SoMaterial* m_material;
};
