/*=============================================================================
** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),       **
**              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                **
**                                                                           **
**  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  **
**  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  **
**  WRITTEN AUTHORIZATION OF FEI S.A.S.                                      **
**                                                                           **
**                        RESTRICTED RIGHTS LEGEND                           **
**  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS **
**  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN **
**  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT **
**  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN **
**  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        **
**                                                                           **
**                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                   **
**                             BORDEAUX, FRANCE                              **
**                           ALL RIGHTS RESERVED                             **
=============================================================================*/

#pragma once

#include <Inventor/actions/SoGLRenderAction.h>

class SoHighlightRenderActionSync;
class SoTraversalPassHighlight;
class SoPath;
class SoSelection;

SO_PIMPL_BASE_PUBLIC_DECLARATION( SoHighlightRenderAction )

/**
 * Abstract base class for Highlight Render Actions
 *
 * @ingroup actions
 *
 * \if_cpp
 * To implement a new Highlight Render Action, the methods
 * getPreTraversalNode() and getPostTraversalNode() can be implemented.
 *
 * If a more complex highlighting is needed, then the apply() method can
 * be re-implemented instead.
 * \else
 * To implement a new Highlight Render Action, the method apply() should be
 * re-implemented.
 * \endif
 *
 * @SEE_ALSO
 *    SoLineHighlightRenderAction,
 *    SoColorHighlightRenderAction,
 *    SoBoxHighlightRenderAction,
 *    SoHaloHighlightRenderAction,
 *    SoGLRenderAction,
 *    SoSelection,
 *    SoWinRenderArea,
 *    SoDrawStyle,
 *    SoInteraction
 *
 *
 */
class INVENTOR_API SoHighlightRenderAction : public SoGLRenderAction
{
  SO_ACTION_HEADER( SoHighlightRenderAction );
  SO_PIMPL_BASE_PUBLIC_HEADER( SoHighlightRenderAction )

public:
#ifndef HIDDEN_FROM_DOC
  /**
   * Destructor
   */
  virtual ~SoHighlightRenderAction();
#endif // HIDDEN_FROM_DOC

  /** @copydoc SoAction::clearApplyResult() */
  virtual void clearApplyResult();

  /**
   * This renders the passed scene graph, and also renders highlighted
   * selected objects as specified by the first SoSelection node found in the scene
   * graph.
   */
  virtual void apply( SoNode* node );

  /**
   * This provides a convenient mechanism for turning highlights off or on. When
   * @B FALSE @b is passed, subsequent calls to apply() render the scene
   * graph without rendering highlights. The application is responsible for forcing a
   * redraw of the scene after changing this state. The default visibility is on.
   */
  void setVisible( SbBool b );

  /**
   * Returns whether highlights will be rendered or not.
   */
  SbBool isVisible() const;

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /**
   * Returns whether or not the current highlight traversal should be done or not.
   */
  virtual bool shouldTraverseHighlightPass() const;

SoEXTENDER protected:
  /**
   * This node will be traversed before the selected shapes during the
   * Highlight Pass.
   *
   * For example, this method can return an SoGroup containing an SoDrawStyle
   * with its style field overrided to SoDrawStyle::LINES and an SoMaterial
   * with its diffuseColor field overrided to (1,0,0), so that the selected
   * shapes will be re-rendered in red wireframe mode.
   *
   * The state is pushed just before traversing this node and popped after
   * traversing the selected shapes, just before traversing the post-traversal
   * node (see getPostTraversalNode()).
   */
  virtual SoNode* getPreTraversalNode() { return nullptr; }

  /**
   * This node will be traversed after the selected shapes during the
   * Highlight Pass. This can be useful if any post-treatment needs to be done
   * for highlighting after re-traversing the selected shapes.
   *
   * The state is pushed just before traversing the pre-traversal node
   * (see getPreTraversalNode()) and popped after traversing the selected
   * shapes, just before traversing this node.
   */
  virtual SoNode* getPostTraversalNode() { return nullptr; }

protected:
  /**
   * Protected constructor: this is an abstract class.
   */
  SoHighlightRenderAction();

  /**
   * Constructor which takes the normal SoGLRenderAction parameters.
   */
  SoHighlightRenderAction( const SbViewportRegion& viewportRegion );

private:
  // Copy Constructor Forbidden
  SoHighlightRenderAction( const SoHighlightRenderAction& ) : SoGLRenderAction( SbVec2s( 1, 1 ) ) {}

  void commonConstructor();

  friend class ::SoHighlightRenderActionSync;
  friend class ::SoTraversalPassHighlight;
  friend class inventor::impl::SoHighlightRenderActionImpl;
};
