/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Oct 2003)
**=======================================================================*/


#ifndef  _SO_SEARCHSTEP_ACTION_
#define  _SO_SEARCHSTEP_ACTION_

#include <Inventor/actions/SoSearchAction.h>

class SoSearchStepAction;

/** 
 * @VSGEXT Searches for nodes in the scene graph step by step.
 * 
 * @ingroup actions
 * 
 * @DESCRIPTION
 *  This class extends SoSearchAction.
 *  This class allows the user to add a \if_dotnet delegate \else callback \endif to control which paths are added
 *  to the path list.
 *  This user \if_dotnet delegate \else callback \endif is called just before the found path would be added to the list. It
 *  determines whether or not the path will be added to the list. 
 *  The use of this class is particularly interesting when the found paths are potentially
 *  numerous and the user wants to filter the returned path list to retrieve only some of them.
 *
 * @SEE_ALSO
 *    SoSearchAction,
 *    SoSearchPathAction
 * 
 */
class INVENTOR_API SoSearchStepAction : public SoSearchAction {

  SO_ACTION_HEADER(SoSearchStepAction);

 public:

  /**
   * Constructor.
   */
  SoSearchStepAction();

  /**
   * Destructor.
   */
  virtual ~SoSearchStepAction();

  /** 
  * SoSearchStepAction callback function prototype.
  * @param foundPath Corresponds to the current found path.
  * @param userData Is the data passed by user.
  * @param thisSSA Retrieves the inquiring SoSearchStepAction instance.
  */
typedef SbBool AddingPathCallback(SoFullPath* foundPath, void* userData, SoSearchStepAction* thisSSA);

  /**
   * Add the user callback that the SearchAction must call while building the
   * path list.
   * [OIV-WRAPPER-CUSTOM-CODE]
   */
 void setAddingPathCallBack(AddingPathCallback *ap_cb, void *u_data);

SoEXTENDER public:
  virtual void    setFound();

SoINTERNAL public:
  static void     initClass();
  static void     exitClass();

private:
    AddingPathCallback *addingPathCB;
    void *addingPathCB_udata;
};

#endif /* _SO_SEARCHSTEP_ACTION_ */

