/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#if !defined(SO_ACCUMULATIONANTIALIASING_PARAMETERS_H)
#define SO_ACCUMULATIONANTIALIASING_PARAMETERS_H

#include <Inventor/antialiasing/SoAntialiasingParameters.h>

/** 
 * @VSGEXT Antialiasing parameters class for the accumulation buffer algorithm.
 *
 * @ingroup Antialiasing
 *
 * @DESCRIPTION
 * This class provides the different parameters that can be set to 
 * configure the accumulation buffer antialiasing algorithm. These objects are used with the
 * setAntialiasing() method in SoSceneManager and some viewer classes (e.g. SoWinGLWidget).
 *
 * There are actually two kinds of antialiasing
 * available: smoothing and multipass antialiasing. If smoothing is set to TRUE,
 * smoothing is enabled. Smoothing uses OpenGL's line- and point-smoothing features
 * to provide cheap antialiasing of lines and points. 
 * Line smoothing is an inexpensive solution for wire frame geometry.
 * The value of numPasses
 * controls multipass antialiasing. Each time a render action is applied, Open
 * Inventor renders the scene numPasses times from slightly different camera
 * positions, averaging the results. numPasses can be from one to 255, inclusive.
 * Setting numPasses to one disables multipass antialiasing. You can use either,
 * both, or neither of these antialiasing techniques. By default, both smoothing
 * and multipass antialiasing are disabled.
 *
 * Increasing the number of render passes can significantly reduce performance for large
 * scenes. As a result this technique has generally been replaced by FSAA and FXAA techniques.
 *
 * @SEE_ALSO
 *   SoFullSceneAntialiasingParameters,
 *   SoFXAAParameters
 */
class INVENTOR_API SoAccumulationAntialiasingParameters : public SoAntialiasingParameters
{
public:
  /** 
   * Constructor which takes as input two parameters.
   * @param smooth Indicates if we want to turn on line and point smoothing.
   * @param numPasses The number of rendering passes we want to accumulate in the accumulation buffers.
   *                  numPasses should be >= 1.
   */
  SoAccumulationAntialiasingParameters(const bool smooth, const int numPasses);

  /** 
   * Returns true if line and point smoothing is requested.
   */
  bool isSmooth() const;

  /** 
   * Returns the number of rendering passes requested for the antialiasing process.
   */
  int getNumPasses() const;

  virtual ~SoAccumulationAntialiasingParameters();

  /** Copy to a new instance */
  virtual SoAntialiasingParameters* copy() const
  {
    return new SoAccumulationAntialiasingParameters( *this );
  }

private:

  bool m_smooth;
  int m_numPasses;
};

#endif // SO_ACCUMULATIONANTIALIASING_PARAMETERS_H
