/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#if !defined(SO_FULLSCENEANTIALIASING_PARAMETERS_H)
#define SO_FULLSCENEANTIALIASING_PARAMETERS_H

#include <Inventor/antialiasing/SoAntialiasingParameters.h>
#include <Inventor/nodes/SoFullSceneAntialiasing.h>

/** 
 * @VSGEXT Antialiasing parameters class for the FSAA algorithm.
 *
 * @ingroup Antialiasing
 *
 * @DESCRIPTION
 * This class provides the different parameters that can be set to 
 * configure the FSAA antialiasing algorithm. These objects are used with the
 * setAntialiasing() method in SoSceneManager and some viewer classes (e.g. SoWinGLWidget).
 *
 * @B Limitations @b
 *
 * The high quality filter is available only on NVidia platforms and only if the
 * extension GL_NV_multisample_filter_hint is available.
 *
 * @SEE_ALSO
 *   SoAccumulationAntialiasingParameters,
 *   SoFXAAParameters,
 *   SoFullSceneAntialiasing
 */
class INVENTOR_API SoFullSceneAntialiasingParameters : public SoAntialiasingParameters
{
public:

  // Mask from SoFullSceneAntialiasing::Filter
  // numSamples override the quality flag of setAntialiasing unless it is set to a negative value

  /**
   * Constructor that takes the different parameters that can be configured.
   *
   * @param numSamples The number of samples we want to enable in the window's pixel format.
   * @param useHQ Indicates if the high quality filter provided by NVidia should be enabled.
   * @param filterMask Is a combination of SoFullSceneAntialiasing::Filter enum 
   *        values to define the primitives affected by the FSAA.
   */
  SoFullSceneAntialiasingParameters(const int numSamples, const bool useHQ, const int filterMask = SoFullSceneAntialiasing::ALL);

  virtual ~SoFullSceneAntialiasingParameters();

  /**  
   * Returns true if the high quality filter is requested. 
   */
  bool useHighQualityFilter() const;

  /** 
   * Returns the requested number of samples.
   * The window's pixel format will have up to this number of samples.
   * If the graphic device doesn't support this number of samples a lower number will be used.
   */
  int getNumSamples() const;

  /**
   * Returns the requested combination of the different values of SoFullSceneAntialiasing::Filter.
   */
  int getFilterMask() const;

  /** Copy to a new instance */
  virtual SoAntialiasingParameters* copy() const
  {
    return new SoFullSceneAntialiasingParameters( *this );
  }

private:
  int m_numSamples;
  bool m_useHQ;
  int m_filterMask;
};

#endif // SO_FULLSCENEANTIALIASING_PARAMETERS_H
