/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MATERIAL_BUNDLE
#define  _SO_MATERIAL_BUNDLE

#include <Inventor/bundles/SoBundle.h>

class SoGLRenderAction;


//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoMaterialBundle
//
//  Bundle that allows shapes to deal with materials more easily.
//  Since materials deal with several elements simultaneously, this
//  bundle hides a lot of this work from shapes.
//
//  Much of the functionality of this bundle has been replaced by the
//  SoLazyElement. 
//
//////////////////////////////////////////////////////////////////////////////

/** [OIV-WRAPPER-CLASS NO_WRAP] */
SoEXTENDER class INVENTOR_API SoMaterialBundle : public SoBundle {

 public:
  // Constructor - takes the action the bundle is used for
  SoMaterialBundle(SoGLRenderAction *action);

  // Destructor
  ~SoMaterialBundle();

  // This can be called by shapes to prepare for sending multiple
  // materials later on. It is not required, since all of the send
  // methods call it if necessary. However, it allows the bundle to
  // set up some optimizations that are not possible to do later on.
  void                setUpMultiple()    
    { accessElements(FALSE, FALSE);
    sendMultiple = TRUE; }

#if SoDEPRECATED_BEGIN(10600)
  SoDEPRECATED_METHOD( 10600, "No longer used." )
  void sendFirst() {}

  SoDEPRECATED_METHOD( 10600, "No longer used." )
  void send(int /*index*/, SbBool /*isBetweenBeginEnd*/) {}

  SoDEPRECATED_METHOD( 10600, "No longer used." )
  void forceSend( int /*index*/ ) {}
#endif /** @DEPRECATED_END */

  // Returns TRUE if only base color part of material is used
  SbBool              isColorOnly() const     { return colorOnly; }

  void         reinitialize(SoState *state);

SoINTERNAL public:
  static bool isSendAlwaysMode()
  {
    return false;
  }

 private:
  SbBool              firstTime;      // TRUE if nothing sent yet
  SbBool              colorOnly;      // TRUE if only base color sent
  SbBool              fastColor;      // TRUE if can send color for diffColor
  int                 numMaterials;   // Number of materials 
  SbBool              sendMultiple;   // indicates multiple diffuse are sent.

  void reallySend( int /*index*/, SbBool /*isBetweenBeginEnd*/, SbBool /*avoidFastColor*/ ) {}

  // Accesses and stores pointers to necessary elements
  void                accessElements(SbBool isBetweenBeginEnd,
                                     SbBool avoidFastColor);
};

#endif /* _SO_MATERIAL_BUNDLE */


