/*=================================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
***                                                                            ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
***                                                                            ***
***                        RESTRICTED RIGHTS LEGEND                            ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
***                                                                            ***
***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                    ***
***                              BORDEAUX, FRANCE                              ***
***                            ALL RIGHTS RESERVED                             ***
=================================================================================*/

#pragma once

#include <Inventor/SbLinear.h>
#include <Inventor/caches/SoCache.h>
#include <Inventor/elements/SoTangentBindingElement.h>

/**
 * Class SoTangentCache:
 *
 * @ingroup Caches
 *
 * A tangent cache stores a list of tangents.
 */
SoEXTENDER class INVENTOR_API SoTangentCache : public SoCache
{
public:
  SoTangentCache( SoState* state );

  virtual ~SoTangentCache();

  /**
   * Stores a list of tangents in the cache
   * [OIV-WRAPPER-ARG NO_WRAP{(tangents != NULL? tangents->Length: 0)},ARRAY]
   */
  void set( int numTangents, const SbVec3f* tangents, SoTangentBindingElement::Binding tangentBinding, int startIndex = 0 );

  /** Returns the number of tangents in the cache */
  int getNum() const
  {
    return m_numTangents;
  }

  /**
   * Returns the list of tangents in the cache
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{GetNum()}]
   * [OIVJAVA-WRAPPER-RETURN-TYPE ARRAY{getNum()}]
   */
  const SbVec3f* getTangents() const
  {
    return m_tangents;
  }

  /** Returns the tangent binding in the cache */
  SoTangentBindingElement::Binding getTangentBinding() const
  {
    return m_tangentBinding;
  }

  /** Returns the startIndex offset in the cache */
  int getStartIndex() const
  {
    return m_startIndex;
  }

private:
  int m_numTangents; // Number of tangents
  const SbVec3f* m_tangents; // Array of tangents
  int m_startIndex; // Offset for index for the tangents (see stardIndex in SoVertexShape not indexed)
  SoTangentBindingElement::Binding m_tangentBinding; // tangent binding
};
