/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_XT_GL_GRAPHIC_DEVICE_H_
#define _SO_XT_GL_GRAPHIC_DEVICE_H_

#include <Inventor/components/SoGLGraphicDevicePeer.h>

/**
 * @VSGEXT Represents the internal part of an OpenGL graphics device 
 * on UNIX systems (Xt-based systems).
 * 
 * @ingroup General
 * 
 * @DESCRIPTION
 * This class represents a X-windows graphics display (Display *).
 * It is used as an internal part of a graphics device for OpenGL.
 * This class declares or implements all required methods used in the
 * SoGLGraphicDevice class. This class is inherited from SoGLGraphicDevicePeer
 * which is viewed and used as a peer in the OpenGL graphics device class.
 * 
 * @SEE_ALSO
 *    SoGraphicConfigTemplate, SoGLGraphicConfigTemplate, 
 *    SoGraphicConfigCompare, SoGLGraphicConfigCompare, 
 *    SoGraphicConfig, SoGraphicDevice, SoGLGraphicDevice.
 * 
 * [OIV-WRAPPER-CLASS NO_WRAP]
 */
SoINTERNAL class INVENTOR_API SoXtGLGraphicDevice : public SoGLGraphicDevicePeer {

 public:

  /**
   * Constructor.
   */
  SoXtGLGraphicDevice(SbGlContextHelper::Display display, SoGLGraphicDevice::DeviceType dt = SoGLGraphicDevice::WINDOW);

  /**
   * Destructor.
   */
  ~SoXtGLGraphicDevice();

  /**
   * Returns a template corresponding to the given graphics configuration.
   */
  SoGLGraphicConfigTemplate getGraphicConfigTemplate(SoGLGraphicConfig *graphicConfig);

  /**
   * Returns the internal display.
   */
  SbGlContextHelper::Display getDisplay();

  /**
   * Returns the default template used by Inventor.
   */
  SoGLGraphicConfigTemplate getDefaultGraphicConfigTemplate();


  /**
   * Returns the type of device.
   */
  SoGLGraphicDevice::DeviceType getType() {return m_deviceType;};


 SoINTERNAL public:

  SoGLGraphicConfigTemplate getDefaultGraphicConfigTemplate( SbBool, SbBool, SbBool );

 protected:

  /**
   * Build the whole OpenGL graphics configs list.
   */
  virtual void buildGraphicConfigsList();

  /**
   * Deletes all the elements of the configs list.
   */
  virtual void clearGraphicConfigsList();

 private:

  SbGlContextHelper::Display m_display;
  SoGLGraphicDevice::DeviceType m_deviceType;

};

#endif /* _SO_XT_GL_GRAPHIC_DEVICE_H_ */

