/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_WIN_STEREOVIEW_TYPE
#define _SO_WIN_STEREOVIEW_TYPE

#include <Inventor/Gui/SoGui.h>
#include <Inventor/sys/port.h>
#include <Inventor/SbBasic.h>
#include <Inventor/nodes/SoCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/Gui/viewers/SoGuiViewer.h>

class SoStereoViewer;
class SoSceneManager;
class SoGLRenderAction;

/**
 * @VSGEXT Class for stereo management.
 *
 * @ingroup Stereo
 *
 * @DESCRIPTION
 *   This class defines a strategy of stereo management. Using a subclass of
 *   SoBaseStereo allows an SoWinViewer object to use a stereoscopic rendering
 *   mode.
 *
 *   Note: because of internal dependant calls between stereo classes and Open Inventor
 *   viewer classes, SoStereoViewer and SoBaseStereo (and inheriting classes) cannot be
 *   used without using SoWinViewer/SoXtViewer/SoQtViewer inheriting classes.
 *
 * @SEE_ALSO
 *    SoStereoViewer,
 *    SoWinViewer,
 *    SoXtViewer,
 *    SoQtViewer
 *
 * [OIVJAVA-WRAPPER-CLASS NO_WRAP]
 */
class INVENTORGUI_API SoBaseStereo
{

public:
  /** Stereo view types */
  enum StereoViewType
  {
    /**
     *  Monoscopic viewing
     */
    NO_STEREO_VIEW = 0,
    /**
     *  Two views interlaced in a single image
     */
    INTERLACED_STEREO = 1,
    /**
     *  Each view displayed in a half screen
     */
    HALF_SCREEN_STEREO = 2,
    /**
     *  Two views superimposed on a single image
     */
    RAW_STEREO = 3,
    /** Ditto */
    OPENGL_STEREO = 3,
    /**
     *  Each view is displayed through a color filter
     */
    ANAGLYPH_STEREO = 4,
    /** Ditto */
    ANAGLYPH = 4,
#ifndef HIDDEN_FROM_DOC
    /**
     *  Uses the SSDI library to set the stereo
     */
    SSDI_STEREO = 5,
#endif
    PASSIVE_STEREO = 6
  };

  /**
   * Constructor.
   */
  SoBaseStereo( SoStereoViewer* stereoViewer = NULL, SoGuiViewer* guiViewer = NULL );

  /**
   * Destructor. The destructor calls clearStereo().
   */
  virtual ~SoBaseStereo();

  /**
   * Sets the stereo viewer.
   */
  void setStereoViewer( SoStereoViewer* viewer = NULL ) { m_stereoViewer = viewer; }

  /**
   * Queries the stereo viewer.
   * [OIV-WRAPPER-CUSTOM-CODE]
   */
  SoStereoViewer* getStereoViewer() { return m_stereoViewer; }

  /**
   * Sets stereo reversal. The left view becomes the right view, and the
   * right view becomes the left view.
   */
  virtual void reverseStereoView( SbBool reverse );

  /**
   * Queries stereo reversal.
   */
  virtual SbBool isStereoViewReversed() const;

  /**
   * Renders the stereo view. You can use the SoNoStereoView subclass to render
   * the view without any stereo effect.
   */
  virtual void renderStereoView();

  /**
   * Queries the stereo view type.
   */
  virtual StereoViewType getStereoViewType() = 0;

  /**
   * Queries ability to clear before rendering. This allows a subclass to forbid the
   * color buffer from being cleared before any rendering. Typically, this takes
   * place after rendering the first view. Then, if canClearBeforeRender()
   * returns FALSE, the color buffer can keep previous modifications, such as for the
   * stencil buffer, etc.
   */
  virtual SbBool canClearBeforeRender() const;

  /**
   * Returns true or false depending on the type of stereo buffering.
   */
  virtual SbBool requireHardware() { return FALSE; }

  /**
   * A stereo view type may need to restore a state when it is no longer used by a
   * stereo viewer.
   */
  virtual void clearStereo();

  /** Apply stereo parameters to the passed SoSceneManager. */
  void setStereoElement( SoSceneManager*, SoCamera::StereoMode stereoMode );

SoINTERNAL public:
  /**
   * in commonConstructor of StereoDialog, setStereoViewType
   * is called to get back the stereo type when reopening.
   * The MP crash if the stereo type is not supported
   * (pure virtuals functions not redefined)-
   * Crash is avoided by calling this function to know if mode
   * is supported or not in MP.
   * Redefine this function to support the mode
   */
  virtual SbBool isMPStereoViewTypeSupported();

  /**
   * Called by setStereoElement depending on the stereo mode.
   */
  virtual void doLeftEyeSettings( SoGLRenderAction* /*action*/ ) {};
  virtual void doRightEyeSettings( SoGLRenderAction* /*action*/ ) {};
  virtual void doMonoscopicSettings( SoGLRenderAction* /*action*/ ) {};

  /**
   * Tell StereoViewer to take care of fast edit nodes or not.
   */
  void setRenderFastEditNodes( SbBool render );

  /**
   * Sets the gui viewer.
   */
  void setGuiViewer( SoGuiViewer* viewer = NULL ) { m_guiViewer = viewer; }

protected:
  // Insert stereo test pattern in SceneManager.
  void insertTestPattern( SoSceneManager* mgr );
  void removeTestPattern( SoSceneManager* mgr );

  SoStereoViewer* m_stereoViewer;
  SoGuiViewer* m_guiViewer;
  SbBool m_renderFastEdit;
  SbBool m_reversed;
  SbBool m_clearBuffer;

private:
  SoRef<SoSeparator> m_patternSceneGraph;

  /** Placeholder for SceneManager scenegraph when calling insertTestPattern() */
  SoRef<SoSeparator> m_oldRootSlot;
};

#endif // _SO_WIN_STEREOVIEW_TYPE

