/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_WIN_HALFSCREENSTEREO
#define _SO_WIN_HALFSCREENSTEREO

#include <Inventor/components/stereo/SoBaseStereo.h>

class SoStereoViewer;

/**
 * @VSGEXT Class for half-screen stereo support.
 *
 * @ingroup Stereo
 *
 * @DESCRIPTION
 *   This class implements the half-screen stereo type. The display area is divided
 *   into two parts, one for displaying the left eye view and one for displaying the
 *   right eye view.
 *
 * @SEE_ALSO
 *    SoStereoViewer,
 *    SoBaseStereo,
 *    SoWinViewer
 *    SoXtViewer
 *
 * [OIVJAVA-WRAPPER-CLASS NO_WRAP]
 */
class INVENTORGUI_API SoHalfScreenStereo : public SoBaseStereo
{
public:
  /** Half screen modes */
  enum HalfScreenMode
  {
    /** Overunder fill (default value) */
    OVERUNDER_FILL = 0,
    /** Overunder */
    OVERUNDER,
    /** Side by side fill */
    SIDEBYSIDE_FILL,
    /** Side by side */
    SIDEBYSIDE
  };

  /**
   * Constructor.
   */
  SoHalfScreenStereo( SoStereoViewer* stereoVwr = NULL, SoGuiViewer* guiViewer = NULL );

  /**
   * Destructor.
   */
  ~SoHalfScreenStereo();

  /**
   * Sets half-screen mode. Default is OVERUNDER_FILL.
   */
  void setHalfScreenMode( HalfScreenMode mode );

  /**
   * Queries half-screen mode.
   */
  HalfScreenMode getHalfScreenMode();

  /**
   * Renders the stereo view.
   */
  virtual void renderStereoView();

  /**
   * Always returns SoBaseStereo::HALF_SCREEN_STEREO.
   */
  virtual StereoViewType getStereoViewType();

SoINTERNAL public:
  void doLeftEyeSettings( SoGLRenderAction* action );
  void doRightEyeSettings( SoGLRenderAction* action );
  void doMonoscopicSettings( SoGLRenderAction* action );

private:
  HalfScreenMode m_halfScreenMode;
  SbViewportRegion m_vpRegion;
  short m_leftSav;
  short m_bottomSav;
  short m_widthSav;
  short m_heightSav;
  int m_viewWidth;
  int m_viewHeight;
  int m_lstartx;
  int m_lstarty;
  int m_rstartx;
  int m_rstarty;
};

#endif // _SO_WIN_HALFSCREENSTEREO


