/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_WIN_NO_STEREOVIEW
#define _SO_WIN_NO_STEREOVIEW

#include <Inventor/components/stereo/SoBaseStereo.h>
#include <Inventor/components/stereo/SoStereoViewer.h>

/**
 * @VSGEXT Makes a stereo viewer behave like a monoscopic (non-stereo) viewer.
 *
 * @ingroup Stereo
 *
 * @DESCRIPTION
 *   SoNoStereoView makes a stereo viewer behave as if it were a monoscopic
 *   viewer. Modifying the stereo view technique has no effect.
 *
 * @SEE_ALSO
 *    SoStereoViewer,
 *    SoBaseStereo,
 *    SoWinViewer
 *
 * [OIVNET-WRAPPER-CLASS MODULE{INVENTORW}]
 */
class SoNoStereoView : public SoBaseStereo
{
public:
  /**
   * Constructor.
   */
  SoNoStereoView( SoStereoViewer* stereoVwr = NULL, SoGuiViewer* guiViewer = NULL )
  : SoBaseStereo( stereoVwr, guiViewer )
  {
  }

  /**
   * Destructor.
   */
  ~SoNoStereoView() {}

  /**
   * Renders the stereo view. It calls the @B actualRendering @b method of the
   * SoStereoViewer only once, without modifying any parameters, such as the
   * camera.
   */
  virtual void renderStereoView()
  {
    if ( m_stereoViewer != NULL )
      m_stereoViewer->actualRendering();
  }

  /**
   * Always returns SoBaseStereo::NO_STEREO_VIEW.
   */
  virtual StereoViewType getStereoViewType() { return NO_STEREO_VIEW; }
};

#endif // _SO_WIN_NO_STEREOVIEW
