/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_WIN_SSDISTEREO
#define _SO_WIN_SSDISTEREO

#if defined(_WIN32)

#include <Inventor/components/stereo/SoBaseStereo.h>
#include <Inventor/components/stereo/ssdi.h>

class SoStereoViewer;

/**
 * @VSGEXT Class for SSDI stereo support.
 *
 * @ingroup Stereo
 *
 * @DESCRIPTION
 *   This class implements the SSDI stereo type [Win32 only].
 *
 *   ATTENTION: THIS CLASS IS NO LONGER FUNCTIONAL DUE TO THE DEMISE OF SSDI.
 *
 *   This type of stereo relies on the SSDI library. This library, which is provided
 *   by VRex Systems (http://www.vrex.com), is capable of supporting a large variety
 *   of stereo systems (shutter glasses, polarized projectors, etc.). Once the
 *   library is installed on the system, choose which driver the library will make
 *   use of (according to the hardware connected to your system), and activate the
 *   SSDI stereo.
 *
 * @SEE_ALSO
 *    SoStereoViewer,
 *    SoBaseStereo,
 *    SoWinViewer
 */
SoINTERNAL class INVENTORW_API SoSSDIStereo : public SoBaseStereo
{
public:

  /**
   * Constructor.
   */
  SoSSDIStereo( SoStereoViewer* stereoVwr = NULL, SoGuiViewer* guiViewer = NULL );

  /**
   * Destructor.
   */
  ~SoSSDIStereo();

  /**
   * Sets stereo reversal.
   */
  virtual void reverseStereoView( SbBool reverse );

  /**
   * Queries stereo reversal.
   */
  virtual SbBool isStereoViewReversed();

  /**
   * Renders the stereo view.
   */
  virtual void renderStereoView();
  virtual void renderMPStereoView();

  /**
   * Always returns SoBaseStereo::SSDI_STEREO.
   */
  virtual StereoViewType getStereoViewType() { return SSDI_STEREO; }

  /**
   * Queries ability to clear before rendering.
   */
  virtual SbBool canClearBeforeRender();

  /**
   * Clears stereo.
   */
  virtual void clearStereo();

  void doLeftEyeSettings( SoGLRenderAction* action );
  void doRightEyeSettings( SoGLRenderAction* action );
  void doMonoscopicSettings( SoGLRenderAction* action );


private:
  SbBool initSSDIStereo();
  int setupStereoBuffers();

  ssdiModeInfo m_modeInfo;
  ssdiStereoInfo m_stereoInfo;
  ssdiDeviceInfo m_deviceInfo;
  ssdiBufferSet m_bufferSet;
  SbBool m_init;
  SbBool m_ssdiEnabled;
  SoBaseStereo* m_stereoRenderer;
};
#endif // _WIN32

#endif // _SO_WIN_SSDISTEREO
