#if !defined(SOGLGLEW_H)
#define SOGLGLEW_H 1

#include <Inventor/sys/port.h>
#include <Inventor/SbBase.h>
#include <Inventor/SoInventorGLEWLibName.h>

#if defined(_WIN32)
#  ifndef InventorGLEW_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__INVENTORGLEWLIB)
#    endif
#  endif
#endif

#ifdef InventorGLEW_EXPORTS
#  define INVENTORGLEW_API VC_DLL_EXPORT
#else
#  define INVENTORGLEW_API VC_DLL_IMPORT
#endif

#if defined(OIV_HEADLESS)
#define glewGetContextNative eglewGetContext
#elif defined(_WIN32)
#define  glewGetContextNative wglewGetContext
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
#define glewGetContextNative glxewGetContext
#else
#define glewGetContextNative glewGetContextMac
#endif

/*! \cond PRIVATE */
namespace SoEGLEW
{
  struct EGLEWContextStruct;
}

namespace SoGLXEW
{
  struct GLXEWContextStruct;
}
/*! \endcond */

SoINTERNAL class INVENTORGLEW_API SoGLGlew
{
public:

#if defined(OIV_HEADLESS)
  typedef struct SoEGLEW::EGLEWContextStruct GlewContextNative;
#elif defined(_WIN32)
  typedef struct WGLEWContextStruct GlewContextNative;
#elif !defined(__APPLE__) || defined(GLEW_APPLE_GLX)
  typedef struct SoGLXEW::GLXEWContextStruct GlewContextNative;
#else
  typedef struct GLEWContextStruct GlewContextNative;
#endif
  SoGLGlew();
  ~SoGLGlew();
  
  // GLEWContext associated to this rendering context.
  struct GLEWContextStruct* m_glewContext;
  GlewContextNative* m_glewContextNative;

  bool m_glewInit;

  // These methods return a pointer to the GLEWContext associated to this context.
  struct GLEWContextStruct* glewGetContextIV() const
  { return m_glewContext; }

  GlewContextNative* glewGetContextNativeIV() const
  { return m_glewContextNative; }

  bool isGLEWInitialized() { return m_glewInit; }

  /**
   * Initialize memory for GLEW structures.
   */
  void initGLEWContext();
  /**
   * @brief Intialize GLEW. Must be called with a context current.
   */
  bool initGLEW();
  bool initGLXEW();
  bool initEGLEW();
  
  void cleanGLEWContext();
};
#endif // SOGLGLEW_H
