/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/devices/SoCpuBufferObject.h>

#ifndef HIDDEN_FROM_DOC

/**
* @VSGEXT CPU buffer object class declared on the local stack.
*
* @ingroup CpuDevice
*
* @DESCRIPTION
*
* This class provides SoCpuBufferObject buffers declared on the local stack.
*
* The parent class SoCpuBufferObject is a reference counted object, so it
* cannot be created on the stack and can only be destroyed by ref()/unref().
*
* Note: This class doesn't use SO_TYPED_CLASS_HEADER because it must not
* be instanciable outside a local stack (calling createInstance will create
* an SoCpuBufferObject.
*
* Example:
* \par
* \code
*    {
*      SoLocalCpuBufferObject cpuObj;
*      cpuObj.map();
*      . . .
*      cpuObj.unmap();
*    }
* \endcode
*
* [OIV-WRAPPER-NO-WRAP]
*/
SoINTERNAL class INVENTORBASE_API SoLocalCpuBufferObject : public SoCpuBufferObject
{
public:
  /** @copydoc SoCpuBufferObject::SoCpuBufferObject(). */
  SoLocalCpuBufferObject();

  /** @copydoc SoCpuBufferObject::SoCpuBufferObject(). */
  SoLocalCpuBufferObject(void *buffer, size_t size);

  /**
   * @copydoc SoCpuBufferObject::~SoCpuBufferObject().
   * Expose SoCpuBufferObject destructor to allow declaration on the stack 
   */
  virtual ~SoLocalCpuBufferObject();
};
#endif // HIDDEN_FROM_DOC
