/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Apr 2013)
**=======================================================================*/

#if !defined SO_SHARED_GROUP_REFERENCE_LIST_H
#define SO_SHARED_GROUP_REFERENCE_LIST_H

#include <Inventor/SbBase.h>

class SoBaseContextCache;
class SoDeviceContextSharedGroup;

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

SoINTERNAL class INVENTORBASE_API SoSharedGroupReferenceList
{
public:
  // Constructor
  SoSharedGroupReferenceList();

  // Destructor
  ~SoSharedGroupReferenceList();

  // Adds an element for the list
  // @param sharedGroup shared group to add element in
  // @param element element to add to the list
  // @return true if element has been inserted in the sharedgroup dependency list
  //         false otherwise (element was already in another list).
  bool insert(SoDeviceContextSharedGroup* sharedGroup, SoBaseContextCache* element);

  // Removes an element for the list
  // @param sharedGroup shared group to remove element from
  // @param element element to remove from the list
  // @return true if element has been removed from the sharedgroup dependency list
  //         false otherwise (element was not in this sharedgroup list).
  bool remove(SoDeviceContextSharedGroup* sharedGroup, SoBaseContextCache* element);

  // Returns true if the element is in the list
  bool contains(const SoDeviceContextSharedGroup* sharedGroup, const SoBaseContextCache* element) const;

  // Return true if the list is empty
  bool isEmpty() const
  { return (m_headList==NULL); }

  // Returns the head list element
  // usefull when iterating through the list to get a stop condition
  SoBaseContextCache* getHead() const
  { return m_headList; }

  // Returns the number of element currently in the list
  // Nb: should be call for debugging only
  size_t getSize() const;

private:
  SoBaseContextCache* m_headList;
};

SoINTERNAL class INVENTORBASE_API SoSharedGroupReference
{
public:
  // Constructor
  SoSharedGroupReference();
  // Destructor.
  ~SoSharedGroupReference();

  // Returns true if this object is already linked to the given sharedGroup dependency list
  inline bool isLinkedTo(const SoDeviceContextSharedGroup* sharedGroup) const
  { return (m_sharedGroup==sharedGroup); }

private:
  SoDeviceContextSharedGroup* m_sharedGroup;
  SoBaseContextCache* m_next;
  SoBaseContextCache* m_previous;

//! @cond Doxygen_Suppress
  friend class SoSharedGroupReferenceList;
//! @endcond
};


#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // SO_SHARED_GROUP_REFERENCE_LIST_H


