/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Created by : VSG (Feb 2012)
**=======================================================================*/


#ifndef  _SO_BBOX_CACHE_ELEMENT
#define  _SO_BBOX_CACHE_ELEMENT

#include <Inventor/elements/SoSubElement.h>
#include <Inventor/threads/SbThreadMutex.h>

SoEXTENDER class INVENTOR_API SoBBoxCacheElement : public SoElement
{
  SO_ELEMENT_HEADER(SoBBoxCacheElement);

 public:

  /**
   */
  enum CacheMode
  {
    DONT_CACHE = 0,
    DO_CACHE = 1
  };

  /**
   * Sets the boundingBox cache mode.
   */
  static void set(SoState* state, CacheMode cacheMode);

  /**
   *  Returns cache mode.
   */
  static CacheMode get(SoState* state);

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

  /**
  *  Override push() method to keep GL up to date.
  */
  virtual void push(SoState *state);

#if SoDEPRECATED_BEGIN(9810)

  SoDEPRECATED_METHOD(9810, "Not usefull anymore. No specific pop function needed for this element")
  /**
  *  Override pop() method to keep GL up to date.
  */
  virtual void pop(SoState *state, const SoElement *prevTopElement);
#endif /** @DEPRECATED_END */

protected:

  /** Initializes element. */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if cache parameters match.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

SoINTERNAL public:

  /** register in database. */
  static void initClass();

  /** unregister from database. */
  static void exitClass();

protected:

  /** Destructor */
  virtual ~SoBBoxCacheElement();

  CacheMode m_cacheMode;

};

#endif // _SO_BBOX_CACHE_ELEMENT


