/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Jan 2005)
**=======================================================================*/
  
#ifndef  _SO_COLOR_MAP_ELEMENT_
#define  _SO_COLOR_MAP_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>

class SoColorMap ;
/**
* @VSGEXT Stores the current color map.
*
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current color map.
*   @SEE_ALSO
*   SoColorMap
*/

SoEXTENDER_Documented class INVENTOR_API SoColorMapElement : public SoReplacedElement {

  SO_ELEMENT_HEADER( SoColorMapElement );

public:
   /**
   *  Sets the current color map in the state.
   */
   static void        set(SoState* state, SoNode *node, SoColorMap *colorMapNode);

   /**
   *  Gets the current color map in the state.
   */
   static SoColorMap* get(SoState* state);

   /**
   *  Returns the default values.
   */
   static SoColorMap* getDefault();

protected:

  virtual void commonInit();

  /** Initializes element */
  virtual void init(SoState* state);

  SoINTERNAL public:
  // Initializes the SoVolumeData class
  static void initClass();
  static void exitClass();

protected:
  SoColorMap *m_colorMapNode;

  virtual ~SoColorMapElement() ;
};

#endif // _SO_COLOR_MAP_ELEMENT_


