/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_DECIMATION_PERCENTAGE_ELEMENT
#define  _SO_DECIMATION_PERCENTAGE_ELEMENT

#include <Inventor/elements/SoFloatElement.h>

/**
* @VSGEXT Stores the current shape decimation percentage.
* 
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current shape decimation percentage.
*   If the SoDecimationTypeElement is set to "PERCENTAGE",
*   shapes should use this element to determine the desired
*   percentage of the total amount of triangles.
*
*   @SEE_ALSO
*   SoGLRenderAction, SoGetPrimitiveCountAction
*/

SoEXTENDER_Documented class INVENTOR_API SoDecimationPercentageElement : public SoFloatElement {

  SO_ELEMENT_HEADER(SoDecimationPercentageElement);

 public:
  /**
  *  Sets the current decimation in the state.
  */
  static void         set(SoState *state, float comp);

  /**
  *  Sets the current decimation in the state.
  */
   static void         set(SoState *state, SoNode *, float comp);

  /**
  *  Returns current decimation percentage from the state.
  */
  static float        get(SoState *state);

  /**
  *  Returns the default decimation percentage.
  */
  static float        getDefault();

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoDecimationPercentageElement class
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoDecimationPercentageElement();
};

#endif /* _SO_DECIMATION_PERCENTAGE_ELEMENT */


