/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Mar 2012)
**=======================================================================*/

#ifndef _SO_DRAW_BUFFER_ELEMENT_H_
#define _SO_DRAW_BUFFER_ELEMENT_H_

#include <Inventor/SbBasic.h>
#include <Inventor/elements/SoInt32Element.h>

/**
 * @VSGEXT Stores the current draw buffer parameters.
 *
 * @ingroup elements
 *
 * @DESCRIPTION
 * This element stores the current draw buffer parameters used for rendering,
 * including:
 *
 * @SEE_ALSO
 *   
 */
SoEXTENDER_Documented class INVENTOR_API SoDrawBufferElement : public SoInt32Element
{
  SO_ELEMENT_HEADER(SoDrawBufferElement);

public:
  /**
   * Depth function mode as defined by OpenGL.
   */
  enum SoDrawBufferType
  {
    FRONT_LEFT,
    FRONT_RIGHT,
    BACK_LEFT,
    BACK_RIGHT,
    FRONT,
    BACK,
    LEFT,
    RIGHT,
    FRONT_AND_BACK
  };

  /**
  * Sets the depth buffer parameters.
  * This method will (indirectly) call glDepthMask, glDepthFunc, glDepthRange
  * with the new values
  */
  static void set(SoState* state, SoDrawBufferType type );

  /**
  *  Returns current depth buffer parameters.
  */
  static SoDrawBufferType get(SoState* state);

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element. */
  virtual void init(SoState *state);

SoINTERNAL public:

  /** register in database. */
  static void initClass();

  /** unregister from database. */
  static void exitClass();

  /** Returns element type. */
  SoDrawBufferType getType() const { return (SoDrawBufferType)data; }

protected:

  /** Destructor */
  virtual ~SoDrawBufferElement();

  /** Sets the draw buffer parameter in an instance. Has GL side effects. */
  virtual void setElt( SoDrawBufferType );

private:

};

#endif /* _SO_DEPTH_BUFFER_ELEMENT_ */


