/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _SO_EDGE_FLAG_ELEMENT
#define  _SO_EDGE_FLAG_ELEMENT

#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/elements/SoReplacedElement.h>

/**
* @VSGEXT Stores the edge flag values.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the edge flag values.
*   @SEE_ALSO
*   SoEdgeFlag
*/

SoEXTENDER_Documented class INVENTOR_API SoEdgeFlagElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoEdgeFlagElement);

 public:
/**
*  Sets the current flags in the state as marked.
*/
  static void           setMarked(SoState *state, SoNode *node,
                                  int32_t numFlags, const int32_t *flags);

  /**
  *  Sets the current flags in the state as unmarked.
  */
  static void           setUnmarked(SoState *state, SoNode *node,
                                    int32_t numFlags, const int32_t *flags);

  /**
  *  Returns the default values.
  */
  static int            getDefault()    {return -1;}

  /**
  *  Returns the top (current) instance of the element in the state.
  */
  static const SoEdgeFlagElement * getInstance(SoState *state)
    {return getConstElement<SoEdgeFlagElement>(state);}

  /**
  *  Returns the number of marked flags in an instance.
  */
  int32_t               getNumMarked() const            { return numMarked; }
  /**
  *  Returns the number of unmarked flags in an instance.
  */
  int32_t               getNumUnmarked() const          { return numUnmarked; }

  /**
   * Returns the marked flags.
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{GetNumMarked()}]
   * [OIVJAVA-WRAPPER-RETURN-TYPE ARRAY{getNumMarked()}]
   */
  const int32_t *       getMarked() const               { return marked; }
  /**
   * Returns the unmarked flags.
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{GetNumUnmarked()}]
   * [OIVJAVA-WRAPPER-RETURN-TYPE ARRAY{getNumUnmarked()}]
   */
  const int32_t *       getUnmarked() const             { return unmarked; }

  /**
  *  Prints element (for debugging).
  */
  virtual void  print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoEdgeFlagElement class
  static void           initClass();
  static void           exitClass();

  static void           reInit(SoState *, SoNode *);

 protected:
  int32_t               numMarked, numUnmarked;
  const int32_t *       marked;
  const int32_t *       unmarked;

  static int32_t markedDefault[1] ;
  static int32_t unmarkedDefault[1] ;

  virtual ~SoEdgeFlagElement();

 private:
  void _init();
};

#endif /* _SO_EDGE_FLAG_ELEMENT */


