/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Feb 1997)
**=======================================================================*/

#ifndef  _SO_ENVIRONMENT_ELEMENT_
#define  _SO_ENVIRONMENT_ELEMENT_
/* include files */
#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/SbColor.h>

/*----------------------------------------------------------------------------*/
/**
* @VSGEXT Stores the current environment.
*
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current environment.
*   @SEE_ALSO
*   SoEnvironment
*/

SoEXTENDER_Documented class INVENTOR_API SoEnvironmentElement : public SoReplacedElement {
  SO_ELEMENT_HEADER(SoEnvironmentElement) ;

 public:

   /** Fog type */
  enum FogType {
    /** None */
    NONE,
    /** Haze */
    HAZE,
    /** Fog */
    FOG,
    /** Smoke */
    SMOKE
  } ;

  /**
  * EnvironmentParameters packages all the different environment parameters.
  *
  * By default it has each parameter set at its default value, and provides comparison operators.
  * For more info on the meaning of the struct members, please refer to the SoEnvironment node
  *
  */
  struct INVENTOR_API EnvironmentParameters {
    EnvironmentParameters();

    float     ambientIntensity;
    SbColor   ambientColor;
    SbVec3f   attenuation;
    SbBool    ambientOcclusion;
    FogType   fogType;
    SbColor   fogColor;
    float     fogStart;
    float     fogVisibility;
  };

  /**
  *  Sets the current environment in the state.
  */
  static void set(SoState *state, SoNode *node, const EnvironmentParameters& envParams) ;

  /**
  *  Gets the current environment in the state.
  */
  static void get(SoState *state, EnvironmentParameters& envParams) ;

  /**
  *  Gets the ambient intensity.
  */
  static float          getAmbientIntensity(SoState *state) ;

  /**
  *  Gets the ambient color.
  */
  static const SbColor& getAmbientColor(SoState *state) ;

  /**
  *  Gets the light attenuation.
  */
  static const SbVec3f& getLightAttenuation(SoState *state) ;

  /**
  *  Gets the ambient occlusion state (TRUE : activated, otherwise deactivated)
  */
  static const SbBool& getAmbientOcclusion(SoState *state);

  // Push copies the values from the previous element
  virtual void  push(SoState *state) ;

protected:

  /** Initializes element. */
  virtual void init(SoState *state);

  /** Returns TRUE if the attributes of environment  match in both elements */
  virtual SbBool matches(const SoElement* elt) const;

  /** Create and return a copy of this element to be used by matches */
  virtual SoElement* copyMatchInfo() const;
  
 SoINTERNAL public:
  
  // Initializes the SoEnvironmentElement class
  static void initClass() ;
  static void exitClass() ;

protected:
  float     m_ambientIntensity ;
  SbColor   m_ambientColor ;
  SbVec3f   m_attenuation ;
  SbBool    m_ambientOcclusion;
  FogType   m_fogType ;
  SbColor   m_fogColor ;
  float     m_fogStart ;
  float     m_fogVisibility ;

  virtual void setElt(const EnvironmentParameters& envParams) ;

  virtual ~SoEnvironmentElement() ;

} ;

/*----------------------------------------------------------------------------*/

#endif // _SO_ENVIRONMENT_ELEMENT_


