/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
** Modified by : Thad Beier (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_FONT_NAME_ELEMENT
#define  _SO_FONT_NAME_ELEMENT

#include <Inventor/SbString.h>
#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/nodes/SoFont.h>

/**
*   Stores the current font name.
*
*   Default font name is setup at startup by OIV_FONT_NAME environement variable if defined.
*
*   @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current font name.
*
*   @SEE_ALSO
*   SoFont, SoFontStyle
*/

SoEXTENDER_Documented class INVENTOR_API SoFontNameElement : public SoReplacedElement {
  
  SO_ELEMENT_HEADER(SoFontNameElement);
  
 public:
/**
*  Sets the current font name.
*/
  static void set(SoState *state, SoNode *node,
                  const SbString &fontName);
  
  /**
  *  Returns the current font name from the state.
  */
  static const SbString &get(SoState *state);
  
  /**
  *  Returns the default font name.
  */
  static const SbString &getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the font name matches given element.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Creates and returns a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoNormalBindingElement class
  static void initClass();
  static void exitClass();

  // Return the current font node from the state
  static const SoFont *getFontNode(SoState *state);

  // Returns the font name set by the font server
  static const SbString& getFontServerFontName();

  // Sets the font name set by the font server
  static void setFontServerFontName( const SbString& fontName );
  
 protected:
  SbString fontName;
  SoFont *fontNode;
  
  virtual ~SoFontNameElement();
private:
  static SbString s_defaultFontName;
  static SbString s_currentFontName;
  static bool s_isSet;
};

#endif /* _SO_FONT_NAME_ELEMENT */


