/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas Daguise (May 2003)
**=======================================================================*/

#ifndef  _SO_FONT_RENDERSTYLE_ELEMENT
#define  _SO_FONT_RENDERSTYLE_ELEMENT

#include <Inventor/elements/SoInt32Element.h>
/**
* @VSGEXT Stores the current font render style.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current font render style.
*   @SEE_ALSO
*   SoFont
*/

SoEXTENDER_Documented class INVENTOR_API SoFontRenderStyleElement : public SoInt32Element {

  SO_ELEMENT_HEADER(SoFontRenderStyleElement);

 public:
/**
*  These are the available render styles.
*/
  enum RenderStyle {
    POLYGON,
    TEXTURE,
    TEXTURE_DELAYED,
    POLYGON_AND_OUTLINE
  };

  /**
  *  Sets the current render style in the state.
  */
  static void         set(SoState *state, RenderStyle style);

  /**
  *  Sets the current render style in the state.
  */
  static void         set(SoState *state, SoNode *, RenderStyle style) { set(state, style); }

  /**
  *  Returns current render style from the state.
  */
  static RenderStyle      get(SoState *state) { return (RenderStyle)SoInt32Element::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default render style.
  */
  static RenderStyle     getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void           print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoDrawStyleElement class
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoFontRenderStyleElement();

private:
  static RenderStyle s_defaultRenderStyle;
  static bool s_isSet;
};

#endif /* _SO_FONT_RENDERSTYLE_ELEMENT */


