/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Julien SALLANNE (Apr 2009)
**=======================================================================*/

#ifndef  _SO_GEO_RENDER_ELEMENT
#define  _SO_GEO_RENDER_ELEMENT

#include <Inventor/elements/SoInt32Element.h>
#include <Inventor/projection/SbProj4Projection.h>

/**
* @VSGEXT Stores the current render projection
*
* @ingroup elements
*
*   @DESCRIPTION
*
*
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoGeoRenderElement : public SoInt32Element {

  SO_ELEMENT_HEADER(SoGeoRenderElement);

 public:
  /**
  *  Sets the current render mode in the state.
  */
  static void         set(SoState *state, SbProj4Projection::Projection renderProjection)
    { SoInt32Element::set(getClassTypeId(), getClassStackIndex(), state, (int32_t)renderProjection); }

  /**
  *  Sets the current render mode in the state.
  */
  static void         set(SoState *state, SoNode *, SbProj4Projection::Projection renderProjection)
    { set(state, renderProjection); }

  /**
  *  Returns current render mode in the state.
  */
  static SbProj4Projection::Projection    get(SoState *state)
    { return (SbProj4Projection::Projection)SoInt32Element::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default render mode.
  */
  static SbProj4Projection::Projection    getDefault()   { return SbProj4Projection::GEOCENTRIC_PROJ; }

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoGeoRenderElement class
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoGeoRenderElement();
};

#endif /* _SO_GEO_RENDER_ELEMENT */


