/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author(s) : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_INT32_LIST_ELEMENT
#define  _SO_INT32_LIST_ELEMENT

/**
*  Stores a list of int32_t, int, or enum values.
*
* @ingroup elements
*
*   @DESCRIPTION
*   Subclasses store a list of int32_t, int, or enum values. This class
*   defines generic matches() and copy() methods.
*
*   @SEE_ALSO
*/

#include <Inventor/elements/SoSubElement.h>

SoEXTENDER_Documented class INVENTOR_API SoInt32ListElement : public SoElement
{
  SO_ELEMENT_ABSTRACT_HEADER(SoInt32ListElement);

protected:

  /**
  *  Comparison based on value of int32_ts.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /** Copy method, takes care copying the data. */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoInt32ListElement class
  static void initClass();
  static void exitClass();

  // Set value.  Derived classes have static inline methods
  // that pass in the stack index and cast their type into a int32_t.
  // This just gets an appropriate instance and calls the virtual
  // set.
  //static void set(int stackIndex, SoState *state, int32_t value);
  static void set(const SoType& type, int stackIndex, SoState* state, SbIntList& value);

  static void set(const SoType& type, int stackIndex, SoState* state, SoNode*, SbIntList value)
  { set(type, stackIndex, state, value); }

  // Virtual set that subclasses can override to implement
  // side-effect behaviors.
  virtual void setElt(SbIntList& value);

  // Get value.  Derived classes have static inline methods to pass
  // in the stackIndex and cast the returned value to the right type.
  //static SbIntList get(int stackIndex, SoState *state)
  //{ return getConstElement(state, stackIndex)->data; }

  static const SbIntList& get(const SoType& type, int stackIndex, SoState* state)
  { return (static_cast<const SoInt32ListElement*>(getConstElement(state, type, stackIndex)))->data; }

 protected:
  // Storage for data.
  SbIntList data;

  virtual ~SoInt32ListElement();
};

#endif // _SO_INT32_LIST_ELEMENT


