/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author(s) : VSG (Sep 2011)
**=======================================================================*/

#ifndef  _SO_INTERACTIVE_SWITCH_ELEMENT
#define  _SO_INTERACTIVE_SWITCH_ELEMENT

#include <Inventor/elements/SoInt32Element.h>

/**
*   Stores the current interactive switch index.
*
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current interactive switch index. This is set by
*   several nodes and is used to allow SoInteractiveSwitch nodes to inherit the
*   index.
*
*   @SEE_ALSO
*   SoArray, SoMultipleCopy, SoSwitch, SoInteractiveSwitch
*/
SoEXTENDER_Documented class INVENTOR_API SoInteractiveSwitchElement : public SoInt32Element
{

  SO_ELEMENT_HEADER(SoInteractiveSwitchElement);

 public:
  /**
   *  Sets the current switch index in the state.
   */
  static void set(SoState *state, int32_t index)
    { SoInt32Element::set(getClassTypeId(), getClassStackIndex(), state, index); }

  /** Sets the current switch index in the state. */
  static void set(SoState *state, SoNode *, int32_t index)
    { set(state, index); }

  /**
   *  Returns current switch index from the state.
   */
  static int32_t get(SoState *state)
    { return SoInt32Element::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
   *  Returns the default switch index.
   */
  static int32_t getDefault() { return -1; }

protected:

  /** Initializes element */
  virtual void init(SoState* state);

 SoINTERNAL public:
  // Initializes the SoInteractiveSwitchElement class
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoInteractiveSwitchElement();
};

#endif /* _SO_SWITCH_ELEMENT */


