/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Feb 1997)
**=======================================================================*/

#ifndef  _SO_LIGHT_ELEMENT_
#define  _SO_LIGHT_ELEMENT_

/* include files */
#include <Inventor/SoLists.h>
#include <Inventor/elements/SoAccumulatedElement.h>
#include <Inventor/SbMatrix.h>

#include <Inventor/STL/vector>

class SoLight;

/**
* @VSGEXT Stores information on lights.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores information on lights.
*
*   @SEE_ALSO
*   SoLight, SoDirectionalLight, SoPointLight, SoSpotLight
*/

SoEXTENDER_Documented class INVENTOR_API SoLightElement : public SoAccumulatedElement {
  SO_ELEMENT_HEADER(SoLightElement) ;

 public:
  /**
  *  Add to the current light list and to the current matrix list.
  */
  static void add(SoState *state, SoLight *light, const SbMatrix &WCToVRCMatrix) ;

  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void push(SoState *state) ;

  /**
  *  Returns the current list of light nodes from the state.
  */
  static const SoNodeList& getLights(SoState *state) ;

  /**
  *  Returns the matrix transform (WC to VRC) for the light i for an SoCallbackAction.
  *  Returns the modelling matrix for other action.
  */
  static const SbMatrix& getMatrix(SoState *state, int index) ;

  /** @copydoc SoElement::pop() */
  virtual void pop(SoState* state, const SoElement* prevTopElement);

protected:

  /** Initializes element. */
  virtual void init(SoState *state);

 SoINTERNAL public:
  typedef std::vector<SoLight*> LightList;

  // Initializes the SoLightElement class
  static void initClass() ;
  static void exitClass() ;

  /**
   * Returns the current list of light nodes from the state in a stl list
   */
  static void getLights(SoState *state, LightList& lightList);

  /**
   * Returns the current list of light nodes from the state in a stl list
   */
  void getLights( LightList& lightList ) const;

  /** Returns model matrix of given light */
  static void getMatrix(SoState *state, SoLight* light, SbMatrix& model, SbMatrix& view);

 protected:
  /**
  *  Returns TRUE if the element matches another element, based on node-id's.
  */
  virtual SbBool matches(const SoElement* elt) const;

 /**
  * Create and return a copy of this element; this will copy the
  * nodeId list properly.
  */
  virtual SoElement* copyMatchInfo() const;

  // list of light nodes
  SoNodeList m_lights ;

  // List of transform matrix from world coordinates to view reference coordinates
  std::vector<SbMatrix> m_WCToVRCMatrix;
  int        m_startIndex;

  /** List of view matrix */
  std::vector<SbMatrix> m_viewMatrix;

  virtual ~SoLightElement() ;
} ;
/*----------------------------------------------------------------------------*/

#endif // _SO_LIGHT_ELEMENT_


