/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_LINE_PATTERN_ELEMENT
#define  _SO_LINE_PATTERN_ELEMENT

#include <Inventor/elements/SoReplacedElement.h>

/**
*  Stores the current line stipple pattern.
* 
* @ingroup elements
*
*   @DESCRIPTION
*   This slement stores the current line stipple pattern.
* 
*   @SEE_ALSO
*   SoDrawStyle
*/

SoEXTENDER_Documented class INVENTOR_API SoLinePatternElement : public SoReplacedElement {
  
  SO_ELEMENT_HEADER(SoLinePatternElement);
  
 public:
  /**
  *  Sets the current line pattern in the state.
  */
  static void set(SoState *state, 
                  u_short pattern, int factor = 1);
  
  /**
  *  Sets the current line pattern in the state.
  */
  static void set(SoState *state, SoNode *, 
                  u_short pattern, int factor = 1)
    { set(state, pattern, factor); }

  /**
  *  Returns current line pattern from the state. The current line
  *  pattern scale factor from the state is returned in factor.
  */
  static u_short get(SoState *state, int &factor);
  
  /**
  *  Deprecated: Returns the default line pattern.
  */
  static u_short getDefault()
    { return getDefaultPattern(); }
  
  /**
  *  Returns the default line pattern.
  */
  static u_short getDefaultPattern()
    { return 0xFFFF; }
  
  /**
  *  Returns the default line pattern scale factor.
  *  A multiplier for each bit in the line pattern.
  *  If factor is 3, for example, each bit in the
  *  pattern will be used three times before the
  *  next bit in the pattern is used. The factor
  *  parameter is clamped to the range [1, 256] and
  *  defaults to 1.
  */
  static int getDefaultScaleFactor()
    { return 1; }

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the line pattern and line
  *  pattern scale factor match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoLinePatternElement class
  static void initClass();
  static void exitClass();

 protected:
  int m_pattern, m_factor;

  virtual ~SoLinePatternElement();
  virtual void setElt(u_short pattern, int factor);
};

#endif /* _SO_LINE_PATTERN_ELEMENT */


