/*=======================================================================
** Author      : Charles Huet (06 2015)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_LOGIC_OPERATION_ELEMENT_H
#define _SO_LOGIC_OPERATION_ELEMENT_H

#include <Inventor/elements/SoElement.h>
#include <Inventor/elements/SoSubElement.h>
#include <Inventor/SbEnums.h>

/**
 * @VSGEXT Stores the current logical pixel operation for rendering.
 *
 * @ingroup elements
 *
 * This element stores the current logical pixel operation for rendering.
 *
 * A Logical Operation is a Per-Sample Processing operation applied between the Fragment's color values and
 * color values in the Framebuffer being rendered to that correspond to that particular fragment color.
 * Logical operations are boolean operations performed on the bit pattern that represents the colors.
 *
 */
class INVENTOR_API SoLogicOperationElement : public SoElement
{
  SO_ELEMENT_HEADER( SoLogicOperationElement );

public:
  /**
   * Logic Operation as defined by OpenGL's logicOp enum.
   */
  enum LogicOperation
  {
    NOOP          = SbEnums::LOGIC_OP_NOOP,
    CLEAR         = SbEnums::LOGIC_OP_CLEAR,
    SET           = SbEnums::LOGIC_OP_SET,
    COPY          = SbEnums::LOGIC_OP_COPY,
    COPY_INVERTED = SbEnums::LOGIC_OP_COPY_INVERTED,
    INVERT        = SbEnums::LOGIC_OP_INVERT,
    AND           = SbEnums::LOGIC_OP_AND,
    NAND          = SbEnums::LOGIC_OP_NAND,
    AND_REVERSE   = SbEnums::LOGIC_OP_AND_REVERSE,
    AND_INVERTED  = SbEnums::LOGIC_OP_AND_INVERTED,
    OR            = SbEnums::LOGIC_OP_OR,
    NOR           = SbEnums::LOGIC_OP_NOR,
    XOR           = SbEnums::LOGIC_OP_XOR,
    OR_REVERSE    = SbEnums::LOGIC_OP_OR_REVERSE,
    OR_INVERTED   = SbEnums::LOGIC_OP_OR_INVERTED,
    EQUIV         = SbEnums::LOGIC_OP_EQUIV,
  };



  /**
   * @brief set the current logic operation
   * @param state the state from which to retrieve the element instance.
   * @param enable Whether to enable or not logic operations
   * @param operation which operation to apply
   */
  static void set( SoState* state, bool enable, LogicOperation operation );

  /**
   * @brief get the current logic operation, and wether logic operations are enabled.
   * @param state the state from which to retrieve the element instance.
   * @param enabled Whether logic operations are enabled
   * @param operation which operation is applied
   */
  static void get( SoState* state, bool& enabled, LogicOperation& operation );

  /**
  *  Prints element (for debugging).
  */
  virtual void print( FILE* fp ) const;

  /**
  *  Override push() method to keep GL up to date.
  */
  virtual void push( SoState* state );

  /**
  *  Override pop() method to keep GL up to date.
  */
  virtual void pop( SoState* state, const SoElement* prevTopElement );

protected:
  ~SoLogicOperationElement();

  /** Initializes element. */
  virtual void init( SoState* state );

  /**
  *  Returns TRUE if depth parameters match.
  */
  virtual SbBool matches( const SoElement* element ) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

SoINTERNAL public :

    /** register in database. */
  static void initClass();

  /** unregister from database. */
  static void exitClass();

  virtual void setElt( const bool enable, const LogicOperation operation );

protected:
  bool m_enabled;
  LogicOperation m_operation;
};

#endif // _SO_LOGIC_OPERATION_ELEMENT_H
