/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MODEL_SCALE_ELEMENT
#define  _SO_MODEL_SCALE_ELEMENT

#include <Inventor/elements/SoModelMatrixElement.h>

/**
*   Stores the current model scale. This is just to redefine the match method 
*   to track just the scale portion of the model matrix and to use this element
*   to filter changes not related to scaling.
*   Not all the SoModelMatrix are diagonalizable because a SoMatrixTransform
*   or a direct set of the SoModelMatrix with a not diagonalizable matrix,
*   so the getScaleFactor can return a vector containing one or more NaN or zeros.
*   This element has some limitation related to the way transformation also rigid 
*   ones are accumulated. So please use it with attention also because for the 
*   moment the SbMatrix::getTransform method does not return any status
* 
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores just the scale pportion of the current model matrix
*   the cumulative  transformation applied to subsequent shapes. Because the matrix is
*   cumulative, this class is derived from SoAccumulatedElement. The
*   set() method replaces the current matrix, while all the others
*   (mult(), translateBy(), etc.) multiply into it. Node id's of the
*   nodes that affect the element are accumulated properly.
*
*
*   @SEE_ALSO
*   SoMatrixTransform, SoRotation, SoRotationXYZ, SoScale,
*   SoTransform, SoTranslation, SoUnits
*/

class INVENTOR_API SoModelScaleElement : public SoModelMatrixElement {

  SO_ELEMENT_HEADER(SoModelScaleElement);

public:

  /**
  *  Returns current model scale - if the overall SoModelMatrix is diagonazible
  *  Not all the SoModelMatrix are diagonalizable because a SoMatrixTransform
  *  or a direct set of the SoModelMatrix with a not diagonalizable matrix,
  *  so the getScaleFactor can return a vector containing one or more NaN or zeros.
  */
  static const SbVec3f    getScaleFactor(SoState *state);

  /**
  *  Returns the of this element model scale - if the overall SoModelMatrix is diagonazible
  *  Not all the SoModelMatrix are diagonalizable because a SoMatrixTransform
  *  or a direct set of the SoModelMatrix with a not diagonalizable matrix,
  *  so the getScaleFactor can return a vector containing one or more NaN or zeros.
  */
  const SbVec3f    getScaleFactor() const;

  
protected:

  /**
  *  Override standard matches to invalidate on cull-test.
  */
  virtual SbBool matches(const SoElement* elt) const;

 SoINTERNAL public:
  // Initializes the SoModelScaleElement class
  static void         initClass();
  static void         exitClass();

  static const SbVec3f getScaleFactor(const SbMatrix& m);
  
 protected:

  virtual ~SoModelScaleElement();

};


#endif /* _SO_MODEL_SCALE_ELEMENT */


