/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Nov 2007)
**=======================================================================*/


#ifndef SO_MODIFY_LOGICAL_VIEWPORT_ELEMENT_H
#define SO_MODIFY_LOGICAL_VIEWPORT_ELEMENT_H

#include <Inventor/SbViewportRegion.h>
#include <Inventor/elements/SoSubElement.h>

/** 
 * @VSGEXT Stores a logical viewport region subset.
 * 
 * @ingroup elements
 * 
 *   @DESCRIPTION
 *   This element stores a logical viewport region subset.
 * 
 */

SoEXTENDER_Documented class INVENTOR_API SoModifyLogicalViewportElement : public SoElement {
  
  SO_ELEMENT_HEADER(SoModifyLogicalViewportElement);
  
 public:
  /**
  *  Sets the portion of the viewport.
  */
  static void set(SoState *state, const SbVec4f& portion);
  
  /**
  *  Returns the current portion from the state.
  */
  static const SbVec4f &get(SoState *state);

  /**
  *  Returns the default viewport region.
  */
  static SbVec4f getDefault()
    { return SbVec4f( 0.0f, 0.0f, 1.0f, 1.0f ); }

  /**
  *  Returns the top (current) instance of the element in the state.
  *  Note it does NOT cause cache dependency!
  *  It also casts away the const.
  */
  static SoModifyLogicalViewportElement *getInstance(const SoState *state, SbBool &elemIsSet);

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the passes match in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
    // Initializes the SoModifyLogicalViewportElement class
  static void initClass();
  static void exitClass();

 protected:

  virtual ~SoModifyLogicalViewportElement();

private:
  SbVec4f m_portion;
  SbBool  m_isSet;

};
#endif // SO_MODIFY_LOGICAL_VIEWPORT_ELEMENT_H


