/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author(s) : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_MULTI_SWITCH_ELEMENT
#define  _SO_MULTI_SWITCH_ELEMENT

#include <Inventor/elements/SoInt32ListElement.h>
#include <Inventor/nodes/SoMultiSwitch.h>

/**
*   Stores the current multi-switch indices.
*
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current multi-switch indices. This is set by
*   several nodes and is used to allow SoMultiSwitch nodes to inherit the
*   indices and traversal mode.
*
*   @SEE_ALSO
*   SoArray, SoMultipleCopy, SoSwitch, SoMultiSwitch
*/

SoEXTENDER_Documented class INVENTOR_API SoMultiSwitchElement : public SoInt32ListElement
{
  SO_ELEMENT_HEADER(SoMultiSwitchElement);

public:
  /**
  *  Sets the current switch index in the state.
  */
  static void set(SoState *state, SbIntList& index, SoMultiSwitch::TraversalMode traversalMode);

  /**
  *  Sets the current switch index in the state.
  */
  static void set(SoState *state, SoNode *, SbIntList& index, SoMultiSwitch::TraversalMode traversalMode)
  {
    set(state, index, traversalMode);
  }

  /**
  *  Returns current switch index from the state.
  */
  static const SbIntList& get(SoState *state)
  { return SoInt32ListElement::get(getClassTypeId(), getClassStackIndex(), state); }

  static SoMultiSwitch::TraversalMode getTraversalMode(SoState* state)
  { return (static_cast<const SoMultiSwitchElement*>(getConstElement(state, getClassTypeId(), getClassStackIndex())))->traversalMode; }

protected:

  /** Initializes element */
  virtual void init(SoState *state);

SoINTERNAL public:
  // Initializes the SoMultiSwitchElement class
  static void initClass();
  static void exitClass();

protected:
  virtual ~SoMultiSwitchElement();

private:
  SoMultiSwitch::TraversalMode traversalMode;
};

#endif // SoInt32ListElement


