/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NORMAL_ELEMENT
#define  _SO_NORMAL_ELEMENT



#include <Inventor/SbLinear.h>
#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/errors/SoDebugError.h>

/**
*   Allows read-only access to the top element in the state.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This class allows read-only access to the top element in the state
*   to make accessing several values in it more efficient. Individual
*   values must be accessed through this instance.
*
*   @SEE_ALSO
*   SoNormal, SoVertexProperty
*/

SoEXTENDER_Documented class INVENTOR_API SoNormalElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoNormalElement);

 public:
  /**
   * Sets the current normals.
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(normals != NULL? normals->Length: 0)},ARRAY]
   */
  static void         set(SoState *state, SoNode *node,
                          int32_t numNormals, const SbVec3f *normals);

  /**
  *  Returns the top (current) instance of the element in the state.
  */
  static const SoNormalElement * getInstance(SoState *state)
    {return getConstElement<SoNormalElement>(state);}

  /**
  *  Returns the number of normal vectors in an instance.
  */
  int32_t             getNum() const          { return numNormals; }

  /**
  *  Returns the indexed normal from an element.
  */
  const SbVec3f &     get(int index) const
    {
      if (index < 0 || index >= numNormals)
      {
#if defined(_DEBUG)
        SoDebugError::post("SoNormalElement::get",
                           "Index (%d) is out of range 0 - %d",
                           index, numNormals - 1);
#endif
        return defaultNormal;
      }
      return normals[index];
    }

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoNormalElement class
  static void         initClass();
  static void         exitClass();

 protected:
  int32_t             numNormals;
  const SbVec3f       *normals;

  virtual ~SoNormalElement();

 private:
  // This stores a pointer to the default normal so that we can set
  // "normals" to point to it if no other normal has been set.
  static SbVec3f defaultNormal;
};

#endif /* _SO_NORMAL_ELEMENT */


